/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.WrapperImpl;
import com.microsoft.azure.management.storage.BlobContainer;
import com.microsoft.azure.management.storage.BlobContainers;
import com.microsoft.azure.management.storage.ImmutabilityPolicy;
import com.microsoft.azure.management.storage.LegalHold;
import com.microsoft.azure.management.storage.ListContainerItem;
import com.microsoft.azure.management.storage.implementation.BlobContainerImpl;
import com.microsoft.azure.management.storage.implementation.BlobContainerInner;
import com.microsoft.azure.management.storage.implementation.BlobContainersInner;
import com.microsoft.azure.management.storage.implementation.IdParsingUtils;
import com.microsoft.azure.management.storage.implementation.ImmutabilityPolicyImpl;
import com.microsoft.azure.management.storage.implementation.ImmutabilityPolicyInner;
import com.microsoft.azure.management.storage.implementation.LegalHoldImpl;
import com.microsoft.azure.management.storage.implementation.LegalHoldInner;
import com.microsoft.azure.management.storage.implementation.ListContainerItemImpl;
import com.microsoft.azure.management.storage.implementation.ListContainerItemInner;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class BlobContainersImpl
extends WrapperImpl<BlobContainersInner>
implements BlobContainers {
    private final StorageManager manager;

    BlobContainersImpl(StorageManager manager) {
        super((Object)((StorageManagementClientImpl)((Object)manager.inner())).blobContainers());
        this.manager = manager;
    }

    public StorageManager manager() {
        return this.manager;
    }

    @Override
    public BlobContainerImpl defineContainer(String name) {
        return this.wrapContainerModel(name);
    }

    @Override
    public ImmutabilityPolicyImpl defineImmutabilityPolicy(String name) {
        return this.wrapImmutabilityPolicyModel(name);
    }

    private BlobContainerImpl wrapContainerModel(String name) {
        return new BlobContainerImpl(name, this.manager());
    }

    private ImmutabilityPolicyImpl wrapImmutabilityPolicyModel(String name) {
        return new ImmutabilityPolicyImpl(name, this.manager());
    }

    private BlobContainerImpl wrapBlobContainerModel(BlobContainerInner inner) {
        return new BlobContainerImpl(inner, this.manager());
    }

    private ImmutabilityPolicyImpl wrapImmutabilityPolicyModel(ImmutabilityPolicyInner inner) {
        return new ImmutabilityPolicyImpl(inner, this.manager());
    }

    private Observable<ImmutabilityPolicyInner> getImmutabilityPolicyInnerUsingBlobContainersInnerAsync(String id) {
        String resourceGroupName = IdParsingUtils.getValueFromIdByName(id, "resourceGroups");
        String accountName = IdParsingUtils.getValueFromIdByName(id, "storageAccounts");
        String containerName = IdParsingUtils.getValueFromIdByName(id, "containers");
        BlobContainersInner client = (BlobContainersInner)this.inner();
        return client.getImmutabilityPolicyAsync(resourceGroupName, accountName, containerName);
    }

    @Override
    public Observable<ListContainerItem> listAsync(String resourceGroupName, String accountName) {
        BlobContainersInner client = (BlobContainersInner)this.inner();
        return client.listAsync(resourceGroupName, accountName).flatMap((Func1)new Func1<Page<ListContainerItemInner>, Observable<ListContainerItemInner>>(){

            public Observable<ListContainerItemInner> call(Page<ListContainerItemInner> pageInner) {
                return Observable.from((Iterable)pageInner.items());
            }
        }).map((Func1)new Func1<ListContainerItemInner, ListContainerItem>(){

            public ListContainerItem call(ListContainerItemInner inner) {
                return new ListContainerItemImpl(inner, BlobContainersImpl.this.manager());
            }
        });
    }

    @Override
    public Observable<BlobContainer> getAsync(String resourceGroupName, String accountName, String containerName) {
        BlobContainersInner client = (BlobContainersInner)this.inner();
        return client.getAsync(resourceGroupName, accountName, containerName).map((Func1)new Func1<BlobContainerInner, BlobContainer>(){

            public BlobContainer call(BlobContainerInner inner) {
                return new BlobContainerImpl(inner, BlobContainersImpl.this.manager());
            }
        });
    }

    @Override
    public Completable deleteAsync(String resourceGroupName, String accountName, String containerName) {
        BlobContainersInner client = (BlobContainersInner)this.inner();
        return client.deleteAsync(resourceGroupName, accountName, containerName).toCompletable();
    }

    @Override
    public Observable<LegalHold> setLegalHoldAsync(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        BlobContainersInner client = (BlobContainersInner)this.inner();
        return client.setLegalHoldAsync(resourceGroupName, accountName, containerName, tags).map((Func1)new Func1<LegalHoldInner, LegalHold>(){

            public LegalHold call(LegalHoldInner inner) {
                return new LegalHoldImpl(inner, BlobContainersImpl.this.manager());
            }
        });
    }

    @Override
    public Observable<LegalHold> clearLegalHoldAsync(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        BlobContainersInner client = (BlobContainersInner)this.inner();
        return client.clearLegalHoldAsync(resourceGroupName, accountName, containerName, tags).map((Func1)new Func1<LegalHoldInner, LegalHold>(){

            public LegalHold call(LegalHoldInner inner) {
                return new LegalHoldImpl(inner, BlobContainersImpl.this.manager());
            }
        });
    }

    @Override
    public Observable<ImmutabilityPolicy> getImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName) {
        BlobContainersInner client = (BlobContainersInner)this.inner();
        return client.getImmutabilityPolicyAsync(resourceGroupName, accountName, containerName).map((Func1)new Func1<ImmutabilityPolicyInner, ImmutabilityPolicy>(){

            public ImmutabilityPolicy call(ImmutabilityPolicyInner inner) {
                return BlobContainersImpl.this.wrapImmutabilityPolicyModel(inner);
            }
        });
    }

    @Override
    public Completable deleteImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        BlobContainersInner client = (BlobContainersInner)this.inner();
        return client.deleteImmutabilityPolicyAsync(resourceGroupName, accountName, containerName, ifMatch).toCompletable();
    }

    @Override
    public Observable<ImmutabilityPolicy> lockImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        BlobContainersInner client = (BlobContainersInner)this.inner();
        return client.lockImmutabilityPolicyAsync(resourceGroupName, accountName, containerName, ifMatch).map((Func1)new Func1<ImmutabilityPolicyInner, ImmutabilityPolicy>(){

            public ImmutabilityPolicy call(ImmutabilityPolicyInner inner) {
                return new ImmutabilityPolicyImpl(inner, BlobContainersImpl.this.manager());
            }
        });
    }

    @Override
    public Observable<ImmutabilityPolicy> extendImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, int immutabilityPeriodSinceCreationInDays) {
        BlobContainersInner client = (BlobContainersInner)this.inner();
        return client.extendImmutabilityPolicyAsync(resourceGroupName, accountName, containerName, ifMatch, immutabilityPeriodSinceCreationInDays, null).map((Func1)new Func1<ImmutabilityPolicyInner, ImmutabilityPolicy>(){

            public ImmutabilityPolicy call(ImmutabilityPolicyInner inner) {
                return new ImmutabilityPolicyImpl(inner, BlobContainersImpl.this.manager());
            }
        });
    }
}

