/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.trafficmanager;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ExternalChildResource;
import com.microsoft.azure.management.resources.fluentcore.model.Attachable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Settable;
import com.microsoft.azure.management.trafficmanager.EndpointMonitorStatus;
import com.microsoft.azure.management.trafficmanager.EndpointType;
import com.microsoft.azure.management.trafficmanager.GeographicLocation;
import com.microsoft.azure.management.trafficmanager.TrafficManagerProfile;
import com.microsoft.azure.management.trafficmanager.implementation.EndpointInner;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Fluent
public interface TrafficManagerEndpoint
extends ExternalChildResource<TrafficManagerEndpoint, TrafficManagerProfile>,
HasInner<EndpointInner> {
    public EndpointType endpointType();

    public EndpointMonitorStatus monitorStatus();

    public boolean isEnabled();

    public long routingWeight();

    public long routingPriority();

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public Set<String> geographicLocationCodes();

    public static interface UpdateStages {

        public static interface WithTrafficDisabledOrEnabled {
            public Update withTrafficDisabled();

            public Update withTrafficEnabled();
        }

        @Beta(value=Beta.SinceVersion.V1_2_0)
        public static interface WithGeographicLocation {
            @Beta(value=Beta.SinceVersion.V1_2_0)
            public Update withGeographicLocation(GeographicLocation var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public Update withGeographicLocations(List<GeographicLocation> var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public Update withoutGeographicLocation(GeographicLocation var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public Update withGeographicLocation(String var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public Update withGeographicLocations(Collection<String> var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public Update withoutGeographicLocation(String var1);
        }

        public static interface WithRoutingPriority {
            public Update withRoutingPriority(int var1);
        }

        public static interface WithRoutingWeight {
            public Update withRoutingWeight(int var1);
        }

        public static interface WithSourceTrafficRegion {
            public Update fromRegion(Region var1);
        }

        public static interface WithNestedProfileConfig {
            public UpdateNestedProfileEndpoint toProfile(TrafficManagerProfile var1);

            public UpdateNestedProfileEndpoint withMinimumEndpointsToEnableTraffic(int var1);
        }

        public static interface WithFqdn {
            public UpdateExternalEndpoint toFqdn(String var1);
        }

        public static interface WithAzureResource {
            public Update toResourceId(String var1);
        }
    }

    public static interface Update
    extends Settable<TrafficManagerProfile.Update>,
    UpdateStages.WithRoutingWeight,
    UpdateStages.WithRoutingPriority,
    UpdateStages.WithGeographicLocation,
    UpdateStages.WithTrafficDisabledOrEnabled {
    }

    public static interface UpdateNestedProfileEndpoint
    extends UpdateStages.WithNestedProfileConfig,
    UpdateStages.WithSourceTrafficRegion,
    Update {
    }

    public static interface UpdateExternalEndpoint
    extends UpdateStages.WithFqdn,
    UpdateStages.WithSourceTrafficRegion,
    Update {
    }

    public static interface UpdateAzureEndpoint
    extends UpdateStages.WithAzureResource,
    Update {
    }

    public static interface UpdateDefinitionStages {

        public static interface WithAttach<ParentT>
        extends Attachable.InUpdate<ParentT>,
        WithRoutingWeight<ParentT>,
        WithRoutingPriority<ParentT>,
        WithGeographicLocation<ParentT>,
        WithTrafficDisabled<ParentT> {
        }

        public static interface WithTrafficDisabled<ParentT> {
            public WithAttach<ParentT> withTrafficDisabled();
        }

        @Beta(value=Beta.SinceVersion.V1_2_0)
        public static interface WithGeographicLocation<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithAttach<ParentT> withGeographicLocation(GeographicLocation var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithAttach<ParentT> withGeographicLocations(List<GeographicLocation> var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithAttach<ParentT> withGeographicLocation(String var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithAttach<ParentT> withGeographicLocations(Collection<String> var1);
        }

        public static interface WithRoutingPriority<ParentT> {
            public WithAttach<ParentT> withRoutingPriority(int var1);
        }

        public static interface WithRoutingWeight<ParentT> {
            public WithAttach<ParentT> withRoutingWeight(int var1);
        }

        public static interface WithEndpointThreshold<ParentT>
        extends WithAttach<ParentT> {
            public WithAttach<ParentT> withMinimumEndpointsToEnableTraffic(int var1);
        }

        public static interface WithSourceTrafficRegionThenThreshold<ParentT> {
            public WithEndpointThreshold<ParentT> fromRegion(Region var1);
        }

        public static interface WithNestedProfile<ParentT> {
            public WithSourceTrafficRegionThenThreshold<ParentT> toProfile(TrafficManagerProfile var1);
        }

        public static interface WithSourceTrafficRegion<ParentT> {
            public WithAttach<ParentT> fromRegion(Region var1);
        }

        public static interface WithFqdn<ParentT> {
            public WithSourceTrafficRegion<ParentT> toFqdn(String var1);
        }

        public static interface WithAzureResource<ParentT> {
            public WithAttach<ParentT> toResourceId(String var1);
        }

        public static interface NestedProfileTargetEndpointBlank<ParentT>
        extends WithNestedProfile<ParentT> {
        }

        public static interface ExternalTargetEndpointBlank<ParentT>
        extends WithFqdn<ParentT> {
        }

        public static interface AzureTargetEndpointBlank<ParentT>
        extends WithAzureResource<ParentT> {
        }
    }

    public static interface UpdateDefinition<ParentT>
    extends UpdateDefinitionStages.AzureTargetEndpointBlank<ParentT>,
    UpdateDefinitionStages.ExternalTargetEndpointBlank<ParentT>,
    UpdateDefinitionStages.NestedProfileTargetEndpointBlank<ParentT>,
    UpdateDefinitionStages.WithAzureResource<ParentT>,
    UpdateDefinitionStages.WithFqdn<ParentT>,
    UpdateDefinitionStages.WithSourceTrafficRegion<ParentT>,
    UpdateDefinitionStages.WithSourceTrafficRegionThenThreshold<ParentT>,
    UpdateDefinitionStages.WithEndpointThreshold<ParentT>,
    UpdateDefinitionStages.WithAttach<ParentT> {
    }

    public static interface DefinitionStages {

        public static interface WithAttach<ParentT>
        extends Attachable.InDefinition<ParentT>,
        WithRoutingWeight<ParentT>,
        WithRoutingPriority<ParentT>,
        WithGeographicLocation<ParentT>,
        WithTrafficDisabled<ParentT> {
        }

        public static interface WithTrafficDisabled<ParentT> {
            public WithAttach<ParentT> withTrafficDisabled();
        }

        @Beta(value=Beta.SinceVersion.V1_2_0)
        public static interface WithGeographicLocation<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithAttach<ParentT> withGeographicLocation(GeographicLocation var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithAttach<ParentT> withGeographicLocations(List<GeographicLocation> var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithAttach<ParentT> withGeographicLocation(String var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithAttach<ParentT> withGeographicLocations(Collection<String> var1);
        }

        public static interface WithRoutingPriority<ParentT> {
            public WithAttach<ParentT> withRoutingPriority(int var1);
        }

        public static interface WithRoutingWeight<ParentT> {
            public WithAttach<ParentT> withRoutingWeight(int var1);
        }

        public static interface WithEndpointThreshold<ParentT>
        extends WithAttach<ParentT> {
            public WithAttach<ParentT> withMinimumEndpointsToEnableTraffic(int var1);
        }

        public static interface WithSourceTrafficRegionThenThreshold<ParentT> {
            public WithEndpointThreshold<ParentT> fromRegion(Region var1);
        }

        public static interface WithNestedProfile<ParentT> {
            public WithSourceTrafficRegionThenThreshold<ParentT> toProfile(TrafficManagerProfile var1);
        }

        public static interface WithSourceTrafficRegion<ParentT> {
            public WithAttach<ParentT> fromRegion(Region var1);
        }

        public static interface WithFqdn<ParentT> {
            public WithSourceTrafficRegion<ParentT> toFqdn(String var1);
        }

        public static interface WithAzureResource<ParentT> {
            public WithAttach<ParentT> toResourceId(String var1);
        }

        public static interface NestedProfileTargetEndpointBlank<ParentT>
        extends WithNestedProfile<ParentT> {
        }

        public static interface ExternalTargetEndpointBlank<ParentT>
        extends WithFqdn<ParentT> {
        }

        public static interface AzureTargetEndpointBlank<ParentT>
        extends WithAzureResource<ParentT> {
        }
    }

    public static interface Definition<ParentT>
    extends DefinitionStages.AzureTargetEndpointBlank<ParentT>,
    DefinitionStages.ExternalTargetEndpointBlank<ParentT>,
    DefinitionStages.NestedProfileTargetEndpointBlank<ParentT>,
    DefinitionStages.WithAzureResource<ParentT>,
    DefinitionStages.WithFqdn<ParentT>,
    DefinitionStages.WithSourceTrafficRegion<ParentT>,
    DefinitionStages.WithSourceTrafficRegionThenThreshold<ParentT>,
    DefinitionStages.WithEndpointThreshold<ParentT>,
    DefinitionStages.WithAttach<ParentT> {
    }
}

