/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.springcloud;

import com.microsoft.azure.maven.AbstractAzureMojo;
import com.microsoft.azure.maven.springcloud.config.AppDeploymentMavenConfig;
import com.microsoft.azure.maven.springcloud.config.ConfigurationParser;
import com.microsoft.azure.toolkit.lib.common.proxy.ProxyManager;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudAppConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Settings;

public abstract class AbstractMojoBase
extends AbstractAzureMojo {
    private static final String PROXY = "proxy";
    public static final String TELEMETRY_KEY_PUBLIC = "public";
    public static final String TELEMETRY_KEY_RUNTIME_VERSION = "runtimeVersion";
    public static final String TELEMETRY_KEY_CPU = "cpu";
    public static final String TELEMETRY_KEY_MEMORY = "memory";
    public static final String TELEMETRY_KEY_INSTANCE_COUNT = "instanceCount";
    public static final String TELEMETRY_KEY_JVM_OPTIONS = "jvmOptions";
    public static final String TELEMETRY_KEY_WITHIN_PARENT_POM = "isExecutedWithinParentPom";
    public static final String TELEMETRY_KEY_SUBSCRIPTION_ID = "subscriptionId";
    public static final String TELEMETRY_KEY_JAVA_VERSION = "javaVersion";
    public static final String TELEMETRY_KEY_POM_FILE_MODIFIED = "isPomFileModified";
    public static final String TELEMETRY_KEY_AUTH_METHOD = "authMethod";
    public static final String TELEMETRY_VALUE_AUTH_POM_CONFIGURATION = "Pom Configuration";
    public static final String TELEMETRY_KEY_PLUGIN_NAME = "pluginName";
    public static final String TELEMETRY_KEY_PLUGIN_VERSION = "pluginVersion";
    @Parameter(alias="public")
    protected Boolean isPublic;
    @Parameter(property="clusterName")
    protected String clusterName;
    @Parameter(property="appName")
    protected String appName;
    @Parameter(property="runtimeVersion")
    protected String runtimeVersion;
    @Parameter(property="deployment")
    protected AppDeploymentMavenConfig deployment;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;

    protected void initTelemetryProxy() {
        super.initTelemetryProxy();
        SpringCloudAppConfig configuration = this.getConfiguration();
        String javaVersion = String.format("%s %s", System.getProperty("java.vendor"), System.getProperty("java.version"));
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_PLUGIN_NAME, this.plugin.getArtifactId());
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_PLUGIN_VERSION, this.plugin.getVersion());
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_WITHIN_PARENT_POM, String.valueOf(this.project.getPackaging().equalsIgnoreCase("pom")));
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_JAVA_VERSION, javaVersion);
        this.telemetryProxy.addDefaultProperty(PROXY, String.valueOf(ProxyManager.getInstance().isProxyEnabled()));
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_AUTH_METHOD, TELEMETRY_VALUE_AUTH_POM_CONFIGURATION);
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_PUBLIC, String.valueOf(configuration.isPublic()));
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_RUNTIME_VERSION, configuration.getRuntimeVersion());
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_CPU, String.valueOf(configuration.getDeployment().getCpu()));
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_MEMORY, String.valueOf(configuration.getDeployment().getMemoryInGB()));
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_INSTANCE_COUNT, String.valueOf(configuration.getDeployment().getInstanceCount()));
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_JVM_OPTIONS, String.valueOf(StringUtils.isEmpty((CharSequence)configuration.getDeployment().getJvmOptions())));
        this.telemetryProxy.addDefaultProperty(TELEMETRY_KEY_SUBSCRIPTION_ID, configuration.getSubscriptionId());
    }

    public SpringCloudAppConfig getConfiguration() {
        ConfigurationParser parser = ConfigurationParser.getInstance();
        return parser.parse(this);
    }

    public Boolean getIsPublic() {
        return this.isPublic;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public AppDeploymentMavenConfig getDeployment() {
        return this.deployment;
    }
}

