/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.core.managedidentity;

import com.azure.core.management.AzureEnvironment;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManagerWithCache;
import com.microsoft.azure.toolkit.lib.auth.model.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.model.AuthType;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;

public class ManagedIdentityAccount
extends Account {
    @Nullable
    private final AuthConfiguration config;

    public ManagedIdentityAccount(@Nullable AuthConfiguration config) {
        this.config = config;
    }

    @Override
    public AuthType getAuthType() {
        return AuthType.MANAGED_IDENTITY;
    }

    @Override
    public String getClientId() {
        return Optional.ofNullable(this.config).map(AuthConfiguration::getClient).orElse(null);
    }

    @Override
    protected Mono<Boolean> preLoginCheck() {
        return Mono.fromCallable(() -> this.initializeTokenCredentialManager().map(TokenCredentialManager::listTenants).flatMapIterable(Mono::block).count().blockOptional().filter(s -> s > 0L).isPresent());
    }

    @Override
    protected Mono<TokenCredentialManager> createTokenCredentialManager() {
        AzureEnvironment env = Optional.ofNullable(this.config).map(AuthConfiguration::getEnvironment).orElseGet(() -> ((AzureCloud)Azure.az(AzureCloud.class)).getOrDefault());
        return Mono.just((Object)new ManagementIdentityTokenCredentialManager(env, this.getClientId()));
    }

    static class ManagementIdentityTokenCredentialManager
    extends TokenCredentialManagerWithCache {
        public ManagementIdentityTokenCredentialManager(@Nonnull AzureEnvironment environment, @Nullable String clientId) {
            this.environment = environment;
            this.rootCredentialSupplier = () -> new ManagedIdentityCredentialBuilder().clientId(clientId).build();
            this.credentialSupplier = tenantId -> new ManagedIdentityCredentialBuilder().clientId(clientId).build();
        }
    }
}

