/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.model;

import com.azure.core.management.AzureEnvironment;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AzureCliSubscription
extends Subscription {
    @JsonProperty
    private String homeTenantId;
    @JsonProperty
    private String state;
    @JsonProperty(value="isDefault")
    private boolean selected;
    @JsonIgnore
    private AzureEnvironment environment;
    @JsonIgnore
    private String email;

    @JsonProperty(value="user")
    public void setUser(Map<String, String> user) {
        this.email = user.get("name");
    }

    @JsonProperty(value="cloudName")
    public void setCloudName(String cloudName) {
        this.environment = AzureEnvironmentUtils.stringToAzureEnvironment(cloudName);
    }

    @JsonProperty
    public void setHomeTenantId(String homeTenantId) {
        this.homeTenantId = homeTenantId;
    }

    @JsonProperty
    public void setState(String state) {
        this.state = state;
    }

    @JsonProperty(value="isDefault")
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @JsonIgnore
    public void setEnvironment(AzureEnvironment environment) {
        this.environment = environment;
    }

    @JsonIgnore
    public void setEmail(String email) {
        this.email = email;
    }

    public String getHomeTenantId() {
        return this.homeTenantId;
    }

    public String getState() {
        return this.state;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public AzureEnvironment getEnvironment() {
        return this.environment;
    }

    public String getEmail() {
        return this.email;
    }
}

