/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.action;

import com.microsoft.azure.toolkit.lib.common.action.ActionView;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import com.microsoft.azure.toolkit.lib.common.view.IView;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class Action<D> {
    public static final String SOURCE = "ACTION_SOURCE";
    public static final String RESOURCE_TYPE = "resourceType";
    public static final Id<Runnable> REQUIRE_AUTH = Id.of("action.common.requireAuth");
    public static final Id<Object> AUTHENTICATE = Id.of("action.account.authenticate");
    @Nonnull
    private List<AbstractMap.SimpleEntry<BiPredicate<D, ?>, BiConsumer<D, ?>>> handlers = new ArrayList();
    @Nullable
    private ActionView.Builder view;
    private boolean authRequired = true;
    private Object shortcuts;

    public Action(@Nullable ActionView.Builder view) {
        this.view = view;
    }

    public Action(@Nonnull Consumer<D> handler) {
        this.registerHandler((D d, E e) -> true, (D d, E e) -> handler.accept(d));
    }

    public <E> Action(@Nonnull BiConsumer<D, E> handler) {
        this.registerHandler((D d, E e) -> true, handler);
    }

    public Action(@Nonnull Consumer<D> handler, @Nullable ActionView.Builder view) {
        this.view = view;
        this.registerHandler((D d, E e) -> true, (D d, E e) -> handler.accept(d));
    }

    public <E> Action(@Nonnull BiConsumer<D, E> handler, @Nullable ActionView.Builder view) {
        this.view = view;
        this.registerHandler((D d, E e) -> true, handler);
    }

    private Action(@Nonnull List<AbstractMap.SimpleEntry<BiPredicate<D, ?>, BiConsumer<D, ?>>> handlers, @Nullable ActionView.Builder view) {
        this.view = view;
        this.handlers = handlers;
    }

    @Nullable
    public IView.Label getView(D source) {
        return Objects.nonNull(this.view) ? this.view.toActionView(source) : null;
    }

    public BiConsumer<D, Object> getHandler(D source, Object e) {
        for (int i = this.handlers.size() - 1; i >= 0; --i) {
            AbstractMap.SimpleEntry<BiPredicate<D, ?>, BiConsumer<D, ?>> p = this.handlers.get(i);
            BiPredicate<D, ?> condition = p.getKey();
            BiConsumer<D, ?> handler = p.getValue();
            if (!condition.test(source, e)) continue;
            return handler;
        }
        return null;
    }

    public void handle(D source, Object e) {
        Runnable runnable = () -> {
            BiConsumer<Object, Object> handler = this.getHandler(source, e);
            if (Objects.nonNull(handler)) {
                AzureString title = Optional.ofNullable(this.view).map(b -> b.title).map(t -> (AzureString)t.apply(source)).orElse(AzureString.fromString("<unknown>.<unknown>"));
                AzureTask<Void> task = new AzureTask<Void>(title, () -> this.handle(source, e, handler));
                task.setType(AzureOperation.Type.ACTION.name());
                AzureTaskManager.getInstance().runInBackground(task);
            }
        };
        if (this.authRequired) {
            Action<Runnable> requireAuth = AzureActionManager.getInstance().getAction(REQUIRE_AUTH);
            if (Objects.nonNull(requireAuth)) {
                requireAuth.handle(runnable, e);
            }
        } else {
            runnable.run();
        }
    }

    protected void handle(D source, Object e, BiConsumer<D, Object> handler) {
        if (source instanceof AzResource) {
            AzResource resource = (AzResource)source;
            OperationContext context = OperationContext.action();
            context.setTelemetryProperty("subscriptionId", resource.getSubscriptionId());
            context.setTelemetryProperty(RESOURCE_TYPE, resource.getFullResourceType());
        }
        handler.accept(source, e);
    }

    public void handle(D source) {
        this.handle(source, null);
    }

    public void registerHandler(@Nonnull Predicate<D> condition, @Nonnull Consumer<D> handler) {
        this.handlers.add(new AbstractMap.SimpleEntry<BiPredicate<Object, Object>, BiConsumer<Object, Object>>((d, e) -> condition.test(d), (d, e) -> handler.accept(d)));
    }

    public <E> void registerHandler(@Nonnull BiPredicate<D, E> condition, @Nonnull BiConsumer<D, E> handler) {
        this.handlers.add(new AbstractMap.SimpleEntry<BiPredicate<D, E>, BiConsumer<D, E>>(condition, handler));
    }

    public static Action<Void> retryFromFailure(@Nonnull Runnable handler) {
        return new Action<Void>(v -> handler.run(), new ActionView.Builder("Retry"));
    }

    @Nullable
    public ActionView.Builder getView() {
        return this.view;
    }

    public Action<D> setAuthRequired(boolean authRequired) {
        this.authRequired = authRequired;
        return this;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public Action<D> setShortcuts(Object shortcuts) {
        this.shortcuts = shortcuts;
        return this;
    }

    public Object getShortcuts() {
        return this.shortcuts;
    }

    public static class Id<D> {
        @Nonnull
        private final String id;

        private Id(@Nonnull String id) {
            this.id = id;
        }

        public static <D> Id<D> of(@Nonnull String id) {
            assert (StringUtils.isNotBlank((CharSequence)id)) : "action id can not be blank";
            return new Id<D>(id);
        }

        @Nonnull
        public String getId() {
            return this.id;
        }
    }
}

