/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.action;

import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.ActionGroup;
import com.microsoft.azure.toolkit.lib.common.action.IActionGroup;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public abstract class AzureActionManager {
    private static AzureActionManager instance;

    protected static void register(AzureActionManager manager) {
        if (instance != null) {
            AzureMessager.getDefaultMessager().warning("ActionManager is already registered", null, new Object[0]);
            return;
        }
        instance = manager;
    }

    public abstract <D> void registerAction(Action.Id<D> var1, Action<D> var2);

    public <D> void registerAction(Action.Id<D> id, Consumer<D> action) {
        this.registerAction(id, new Action<D>(action));
    }

    public abstract <D> Action<D> getAction(Action.Id<D> var1);

    public abstract void registerGroup(String var1, ActionGroup var2);

    public abstract IActionGroup getGroup(String var1);

    public <D> void registerHandler(@Nonnull Action.Id<D> id, @Nonnull Predicate<D> condition, @Nonnull Consumer<D> handler) {
        Action<D> action = this.getAction(id);
        action.registerHandler(condition, handler);
    }

    public <D> void registerHandler(@Nonnull Action.Id<D> id, @Nonnull Consumer<D> handler) {
        Action<Object> action = this.getAction(id);
        action.registerHandler((D o) -> true, handler);
    }

    public <D, E> void registerHandler(@Nonnull Action.Id<D> id, @Nonnull BiPredicate<D, E> condition, @Nonnull BiConsumer<D, E> handler) {
        Action<D> action = this.getAction(id);
        action.registerHandler(condition, handler);
    }

    public <D, E> void registerHandler(@Nonnull Action.Id<D> id, @Nonnull BiConsumer<D, E> handler) {
        Action<Object> action = this.getAction(id);
        action.registerHandler((D r, E e) -> true, handler);
    }

    @Nonnull
    public Shortcuts getIDEDefaultShortcuts() {
        return new Shortcuts(){};
    }

    public static AzureActionManager getInstance() {
        return instance;
    }

    public static interface Shortcuts {
        default public Object add() {
            return null;
        }

        default public Object delete() {
            return null;
        }

        default public Object view() {
            return null;
        }

        default public Object edit() {
            return null;
        }

        default public Object refresh() {
            return null;
        }

        default public Object start() {
            return null;
        }

        default public Object stop() {
            return null;
        }

        default public Object restart() {
            return null;
        }

        default public Object deploy() {
            return null;
        }
    }
}

