/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsGettingById;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsGettingByName;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsGettingByResourceGroup;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsDeletingById;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListing;
import com.google.common.collect.Sets;
import com.microsoft.azure.toolkit.lib.AzService;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.Debouncer;
import com.microsoft.azure.toolkit.lib.common.utils.TailingDebouncer;
import com.microsoft.azure.toolkit.lib.resource.GenericResource;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzResourceModule<T extends AbstractAzResource<T, P, R>, P extends AbstractAzResource<P, ?, ?>, R>
implements AzResourceModule<T, P, R> {
    private static final Logger log;
    @Nonnull
    private final String name;
    @Nonnull
    protected final P parent;
    @Nonnull
    private final AtomicLong syncTimeRef = new AtomicLong(-1L);
    @Nonnull
    private final Map<String, Optional<T>> resources = new CaseInsensitiveMap();
    @Nonnull
    private final Debouncer fireEvents = new TailingDebouncer(this::fireChildrenChangedEvent, 300);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    @Override
    @AzureOperation(name="resource.refresh.type", params={"this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    public void refresh() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            log.debug("[{}]:refresh()", (Object)this.name);
            this.syncTimeRef.set(-1L);
            AzureEventBus.emit("module.refreshed.module", this);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<T> list() {
        log.debug("[{}]:list()", (Object)this.name);
        Azure.az(IAzureAccount.class).account();
        AtomicLong atomicLong = this.syncTimeRef;
        synchronized (atomicLong) {
            while (this.syncTimeRef.get() == 0L) {
                try {
                    this.syncTimeRef.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.syncTimeRef.set(-1L);
                }
            }
            if (this.syncTimeRef.compareAndSet(-1L, 0L)) {
                log.debug("[{}]:list->this.reload()", (Object)this.name);
                this.reloadResources();
            }
            log.debug("[{}]:list->this.resources.values()", (Object)this.name);
            return this.resources.values().stream().filter(Optional::isPresent).map(Optional::get).sorted(Comparator.comparing(AbstractAzResource::getName)).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadResources() {
        Stream<AbstractAzResource> loaded;
        log.debug("[{}]:reload()", (Object)this.name);
        try {
            log.debug("[{}]:reload->loadResourcesFromAzure()", (Object)this.name);
            loaded = this.loadResourcesFromAzure();
        }
        catch (Throwable t) {
            log.debug("[{}]:reload->loadResourcesFromAzure()=EXCEPTION", (Object)this.name, (Object)t);
            AtomicLong atomicLong = this.syncTimeRef;
            synchronized (atomicLong) {
                this.syncTimeRef.compareAndSet(0L, -1L);
                this.syncTimeRef.notifyAll();
            }
            AzureMessager.getMessager().error(t);
            return;
        }
        Map<String, AbstractAzResource> loadedResources = loaded.map(this::newResource).collect(Collectors.toMap(AbstractAzResource::getName, r -> r));
        this.setResources(loadedResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResources(Map<String, T> loadedResources) {
        AtomicLong atomicLong = this.syncTimeRef;
        synchronized (atomicLong) {
            Set localResources = this.resources.values().stream().filter(Optional::isPresent).map(Optional::get).map(AbstractAzResource::getName).collect(Collectors.toSet());
            Set creating = this.resources.values().stream().filter(Optional::isPresent).map(Optional::get).filter(r -> "Creating".equals(r.getStatus())).map(AbstractAzResource::getName).collect(Collectors.toSet());
            log.debug("[{}]:reload().creating={}", (Object)this.name, creating);
            Sets.SetView refreshed = Sets.intersection(localResources, loadedResources.keySet());
            log.debug("[{}]:reload().refreshed={}", (Object)this.name, (Object)refreshed);
            Sets.SetView deleted = Sets.difference((Set)Sets.difference(localResources, loadedResources.keySet()), creating);
            log.debug("[{}]:reload().deleted={}", (Object)this.name, (Object)deleted);
            Sets.SetView added = Sets.difference(loadedResources.keySet(), localResources);
            log.debug("[{}]:reload().added={}", (Object)this.name, (Object)added);
            log.debug("[{}]:reload.refreshed->resource.setRemote", (Object)this.name);
            refreshed.forEach(name -> this.resources.get(name).ifPresent(r -> r.setRemote(((AbstractAzResource)loadedResources.get(name)).getRemote())));
            log.debug("[{}]:reload.deleted->deleteResourceFromLocal", (Object)this.name);
            deleted.forEach(name -> Optional.ofNullable(this.deleteResourceFromLocal((String)name, true)).ifPresent(t -> t.setStatus("Deleted")));
            log.debug("[{}]:reload.added->addResourceToLocal", (Object)this.name);
            added.forEach(name -> this.addResourceToLocal((String)name, (T)((AbstractAzResource)loadedResources.get(name)), true));
            this.syncTimeRef.set(System.currentTimeMillis());
            this.syncTimeRef.notifyAll();
        }
    }

    @Nonnull
    public List<T> listByResourceGroup(@Nonnull String resourceGroup) {
        log.debug("[{}]:listByResourceGroupName({})", (Object)this.name, (Object)resourceGroup);
        return this.list().stream().filter(r -> r.getResourceGroupName().equalsIgnoreCase(resourceGroup)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        log.debug("[{}]:clear()", (Object)this.name);
        AtomicLong atomicLong = this.syncTimeRef;
        synchronized (atomicLong) {
            this.resources.clear();
            this.syncTimeRef.set(-1L);
            this.syncTimeRef.notifyAll();
        }
    }

    @Override
    @Nullable
    public T get(@Nullable String name, @Nullable String resourceGroup) {
        log.debug("[{}]:get({}, {})", new Object[]{this.name, name, resourceGroup});
        if (StringUtils.isBlank((CharSequence)name)) {
            log.debug("[{}]:get->isBlank(name)=true", (Object)this.name);
            return null;
        }
        Azure.az(IAzureAccount.class).account();
        if (!this.resources.containsKey(name)) {
            R remote;
            block6: {
                remote = null;
                try {
                    log.debug("[{}]:get({}, {})->loadResourceFromAzure()", new Object[]{this.name, name, resourceGroup});
                    remote = this.loadResourceFromAzure(name, resourceGroup);
                }
                catch (Exception e) {
                    Throwable cause;
                    log.debug("[{}]:get({}, {})->loadResourceFromAzure()=EXCEPTION", new Object[]{this.name, name, resourceGroup, e});
                    Throwable throwable = cause = e instanceof ManagementException ? e : ExceptionUtils.getRootCause((Throwable)e);
                    if (!(cause instanceof ManagementException) || 404 == ((ManagementException)cause).getResponse().getStatusCode()) break block6;
                    log.debug("[{}]:get({}, {})->loadResourceFromAzure()=SC_NOT_FOUND", new Object[]{this.name, name, resourceGroup, e});
                    throw e;
                }
            }
            if (Objects.isNull(remote)) {
                log.debug("[{}]:get({}, {})->addResourceToLocal({}, null)", new Object[]{this.name, name, resourceGroup, name});
                this.addResourceToLocal(name, null, true);
            } else {
                T resource = this.newResource(remote);
                log.debug("[{}]:get({}, {})->addResourceToLocal({}, resource)", new Object[]{this.name, name, resourceGroup, name});
                this.addResourceToLocal(name, resource, true);
            }
        }
        log.debug("[{}]:get({}, {})->this.resources.get({})", new Object[]{this.name, name, resourceGroup, name});
        return (T)((AbstractAzResource)this.resources.get(name).orElse(null));
    }

    @Override
    @Nullable
    public T get(@Nonnull String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        log.debug("[{}]:get({})", (Object)this.name, (Object)resourceId);
        return (T)this.get(id.name(), id.resourceGroupName());
    }

    @Override
    public boolean exists(@Nonnull String name, @Nullable String resourceGroup) {
        log.debug("[{}]:exists({}, {})", new Object[]{this.name, name, resourceGroup});
        AzResource resource = this.get(name, resourceGroup);
        return Objects.nonNull(resource) && ((AbstractAzResource)resource).exists();
    }

    @Override
    public void delete(@Nonnull String name, @Nullable String resourceGroup) {
        log.debug("[{}]:delete({}, {})", new Object[]{this.name, name, resourceGroup});
        log.debug("[{}]:delete->this.get({}, {})", new Object[]{this.name, name, resourceGroup});
        AzResource resource = this.get(name, resourceGroup);
        if (!Objects.nonNull(resource)) {
            throw new AzureToolkitRuntimeException(String.format("resource \"%s\" doesn't exist", name));
        }
        log.debug("[{}]:delete->resource.delete()", (Object)this.name);
        ((AbstractAzResource)resource).delete();
    }

    @Override
    @Nonnull
    public T getOrDraft(@Nonnull String name, @Nullable String resourceGroup) {
        log.debug("[{}]:getOrDraft({}, {})", new Object[]{this.name, name, resourceGroup});
        return (T)Optional.ofNullable(this.get(name, resourceGroup)).orElseGet(() -> (AbstractAzResource)this.cast(this.newDraftForCreate(name, resourceGroup)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public T getOrInit(@Nonnull String name, @Nullable String resourceGroup) {
        log.debug("[{}]:getOrDraft({}, {})", new Object[]{this.name, name, resourceGroup});
        AtomicLong atomicLong = this.syncTimeRef;
        synchronized (atomicLong) {
            return (T)this.resources.getOrDefault(name, Optional.empty()).orElseGet(() -> {
                T resource = this.newResource(name, resourceGroup);
                log.debug("[{}]:get({}, {})->addResourceToLocal({}, resource)", new Object[]{this.name, name, resourceGroup, name});
                this.addResourceToLocal(name, resource, new boolean[0]);
                return resource;
            });
        }
    }

    @Nonnull
    public <D extends AzResource.Draft<T, R>> D updateOrCreate(@Nonnull String name, @Nullable String resourceGroup) {
        log.debug("[{}]:updateOrCreate({}, {})", new Object[]{this.name, name, resourceGroup});
        AzResource resource = this.get(name, resourceGroup);
        if (Objects.nonNull(resource)) {
            return (D)((AzResource.Draft)this.cast(this.newDraftForUpdate(resource)));
        }
        return (D)((AzResource.Draft)this.cast(this.newDraftForCreate(name, resourceGroup)));
    }

    @Nonnull
    public <D extends AzResource.Draft<T, R>> D create(@Nonnull String name, @Nullable String resourceGroup) {
        log.debug("[{}]:create({}, {})", new Object[]{this.name, name, resourceGroup});
        log.debug("[{}]:create->newDraftForCreate({}, {})", new Object[]{this.name, name, resourceGroup});
        return (D)((AzResource.Draft)this.cast(this.newDraftForCreate(name, resourceGroup)));
    }

    @Override
    @Nonnull
    public T create(@Nonnull AzResource.Draft<T, R> draft) {
        log.debug("[{}]:create(draft:{})", (Object)this.name, draft);
        AzResource existing = this.get(draft.getName(), draft.getResourceGroupName());
        if (Objects.isNull(existing)) {
            AbstractAzResource resource = (AbstractAzResource)this.cast(draft);
            log.debug("[{}]:create->addResourceToLocal({})", (Object)this.name, (Object)resource);
            this.addResourceToLocal(resource.getName(), resource, new boolean[0]);
            ResourceId id = ResourceId.fromString((String)resource.getId());
            if (Objects.isNull(id.parent()) && !StringUtils.equalsIgnoreCase((CharSequence)id.subscriptionId(), (CharSequence)NONE.getName()) && !StringUtils.equalsAnyIgnoreCase((CharSequence)id.resourceGroupName(), (CharSequence[])new CharSequence[]{NONE.getName(), "${rg}"})) {
                Optional.ofNullable(resource.getResourceGroup()).map(ResourceGroup::genericResources).ifPresent(m -> {
                    GenericResource genericResource = m.newResource(resource);
                    super.addResourceToLocal(resource.getId(), genericResource, new boolean[0]);
                });
            }
            log.debug("[{}]:create->doModify(draft.createResourceInAzure({}))", (Object)this.name, (Object)resource);
            resource.doModify(draft::createResourceInAzure, "Creating");
            return (T)resource;
        }
        throw new AzureToolkitRuntimeException(String.format("resource \"%s\" is existing", ((AbstractAzResource)existing).getName()));
    }

    @Nonnull
    <D extends AzResource.Draft<T, R>> D update(@Nonnull T resource) {
        log.debug("[{}]:update(resource:{})", (Object)this.name, resource);
        if (((AbstractAzResource)resource).isDraftForCreating()) {
            log.warn("[{}]:updating(resource:{}) from a draftForCreating", (Object)this.name, resource);
        }
        if (((AbstractAzResource)resource).isDraftForUpdating()) {
            return (D)((AzResource.Draft)this.cast(resource));
        }
        log.debug("[{}]:update->newDraftForUpdate({})", (Object)this.name, resource);
        AbstractAzResource draft = (AbstractAzResource)this.cast(this.newDraftForUpdate(resource));
        return (D)((AzResource.Draft)this.cast(draft));
    }

    @Override
    @Nonnull
    public T update(@Nonnull AzResource.Draft<T, R> draft) {
        log.debug("[{}]:update(draft:{})", (Object)this.name, draft);
        AzResource resource = this.get(draft.getName(), draft.getResourceGroupName());
        if (Objects.nonNull(resource) && Objects.nonNull(((AbstractAzResource)resource).getRemote())) {
            log.debug("[{}]:update->doModify(draft.updateResourceInAzure({}))", (Object)this.name, ((AbstractAzResource)resource).getRemote());
            ((AbstractAzResource)resource).doModify(() -> AbstractAzResourceModule.lambda$update$11(draft, (AbstractAzResource)resource), "Updating");
            return (T)resource;
        }
        throw new AzureToolkitRuntimeException(String.format("resource \"%s\" doesn't exist", draft.getName()));
    }

    @Nonnull
    public String toResourceId(@Nonnull String resourceName, @Nullable String resourceGroup) {
        resourceGroup = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{resourceGroup, ((AbstractAzResource)this.getParent()).getResourceGroupName(), "${rg}"});
        return String.format("%s/%s/%s", ((AbstractAzResource)this.parent).getId(), this.getName(), resourceName).replace("${rg}", resourceGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    T deleteResourceFromLocal(@Nonnull String name, boolean ... silent) {
        log.debug("[{}]:deleteResourceFromLocal({})", (Object)this.name, (Object)name);
        log.debug("[{}]:deleteResourceFromLocal->this.resources.remove({})", (Object)this.name, (Object)name);
        AtomicLong atomicLong = this.syncTimeRef;
        synchronized (atomicLong) {
            Optional<T> removed = this.resources.remove(name);
            if (Objects.nonNull(removed) && removed.isPresent() && (silent.length == 0 || !silent[0])) {
                log.debug("[{}]:deleteResourceFromLocal->fireResourcesChangedEvent()", (Object)this.name);
                this.fireEvents.debounce();
            }
            return (T)(Objects.nonNull(removed) ? (AbstractAzResource)removed.orElse(null) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResourceToLocal(@Nonnull String name, @Nullable T resource, boolean ... silent) {
        log.debug("[{}]:addResourceToLocal({}, {})", new Object[]{this.name, name, resource});
        AtomicLong atomicLong = this.syncTimeRef;
        synchronized (atomicLong) {
            Optional oldResource = this.resources.getOrDefault(name, Optional.empty());
            Optional<T> newResource = Optional.ofNullable(resource);
            if (!oldResource.isPresent()) {
                log.debug("[{}]:addResourceToLocal->this.resources.put({}, {})", new Object[]{this.name, name, resource});
                this.resources.put(name, newResource);
                if (newResource.isPresent() && (silent.length == 0 || !silent[0])) {
                    log.debug("[{}]:addResourceToLocal->fireResourcesChangedEvent()", (Object)this.name);
                    this.fireEvents.debounce();
                }
            }
        }
    }

    private void fireChildrenChangedEvent() {
        log.debug("[{}]:fireChildrenChangedEvent()", (Object)this.name);
        if (this.getParent() instanceof AbstractAzServiceSubscription) {
            AzResourceModule service = ((AbstractAzResource)this.getParent()).getModule();
            AzureEventBus.emit("service.children_changed.service", service);
        }
        if (this instanceof AzService) {
            AzureEventBus.emit("service.children_changed.service", this);
        }
        AzureEventBus.emit("resource.children_changed.resource", this.getParent());
        AzureEventBus.emit("module.children_changed.module", this);
    }

    @Nonnull
    @AzureOperation(name="resource.list_resources.type", params={"this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected Stream<R> loadResourcesFromAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            Stream stream;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            log.debug("[{}]:loadResourcesFromAzure()", (Object)this.getName());
            Object client = this.getClient();
            if (client instanceof SupportsListing) {
                log.debug("[{}]:loadResourcesFromAzure->client.list()", (Object)this.name);
                stream = ((SupportsListing)this.cast(client)).list().stream();
            } else {
                if (client != null) {
                    log.debug("[{}]:loadResourcesFromAzure->NOT Supported", (Object)this.name);
                    throw new AzureToolkitRuntimeException("not supported");
                }
                stream = Stream.empty();
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return stream;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    @AzureOperation(name="resource.load_resource.resource|type", params={"name", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected R loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        String string = name;
        String string2 = resourceGroup;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            Object object;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            log.debug("[{}]:loadResourceFromAzure({}, {})", new Object[]{this.getName(), name, resourceGroup});
            Object client = this.getClient();
            resourceGroup = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{resourceGroup, ((AbstractAzResource)this.getParent()).getResourceGroupName()});
            String string3 = resourceGroup = StringUtils.equals((CharSequence)resourceGroup, (CharSequence)"${rg}") ? null : resourceGroup;
            if (client instanceof SupportsGettingById && StringUtils.isNotEmpty((CharSequence)resourceGroup)) {
                log.debug("[{}]:loadResourceFromAzure->client.getById({}, {})", new Object[]{this.name, resourceGroup, name});
                object = ((SupportsGettingById)this.cast(client)).getById(this.toResourceId(name, resourceGroup));
            } else if (client instanceof SupportsGettingByResourceGroup && StringUtils.isNotEmpty((CharSequence)resourceGroup)) {
                log.debug("[{}]:loadResourceFromAzure->client.getByResourceGroup({}, {})", new Object[]{this.name, resourceGroup, name});
                object = ((SupportsGettingByResourceGroup)this.cast(client)).getByResourceGroup(resourceGroup, name);
            } else if (client instanceof SupportsGettingByName) {
                log.debug("[{}]:loadResourceFromAzure->client.getByName({})", (Object)this.name, (Object)name);
                object = ((SupportsGettingByName)this.cast(client)).getByName(name);
            } else {
                log.debug("[{}]:loadResourceFromAzure->this.list().filter({}).getRemote()", (Object)this.name, (Object)name);
                object = this.list().stream().filter(r -> StringUtils.equals((CharSequence)name, (CharSequence)r.getName())).findAny().map(AbstractAzResource::getRemote).orElse(null);
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return (R)object;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="resource.delete_resource.resource|type", params={"nameFromResourceId(resourceId)", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            log.debug("[{}]:deleteResourceFromAzure({})", (Object)this.getName(), (Object)resourceId);
            Object client = this.getClient();
            if (client instanceof SupportsDeletingById) {
                log.debug("[{}]:deleteResourceFromAzure->client.deleteById({})", (Object)this.name, (Object)resourceId);
                ((SupportsDeletingById)client).deleteById(resourceId);
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected AzResource.Draft<T, R> newDraftForCreate(@Nonnull String name, @Nullable String resourceGroup) {
        throw new AzureToolkitRuntimeException("not supported");
    }

    @Nonnull
    protected AzResource.Draft<T, R> newDraftForUpdate(@Nonnull T t) {
        throw new AzureToolkitRuntimeException("not supported");
    }

    @Nonnull
    protected abstract T newResource(@Nonnull R var1);

    @Nonnull
    protected abstract T newResource(@Nonnull String var1, @Nullable String var2);

    @Nullable
    protected Object getClient() {
        throw new AzureToolkitRuntimeException("not implemented");
    }

    @Nonnull
    private <D> D cast(@Nonnull Object origin) {
        return (D)origin;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public P getParent() {
        return this.parent;
    }

    @Nonnull
    public Debouncer getFireEvents() {
        return this.fireEvents;
    }

    public AbstractAzResourceModule(@Nonnull String name, @Nonnull P parent) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        this.name = name;
        this.parent = parent;
    }

    public String toString() {
        return "AbstractAzResourceModule(name=" + this.getName() + ", syncTimeRef=" + this.syncTimeRef + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractAzResourceModule)) {
            return false;
        }
        AbstractAzResourceModule other = (AbstractAzResourceModule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        AzResource this$parent = this.getParent();
        AzResource other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractAzResourceModule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        AzResource $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        return result;
    }

    private static /* synthetic */ Object lambda$update$11(AzResource.Draft draft, AbstractAzResource resource) throws Exception {
        return draft.updateResourceInAzure(resource.getRemote());
    }

    static {
        AbstractAzResourceModule.ajc$preClinit();
        log = LoggerFactory.getLogger(AbstractAzResourceModule.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractAzResourceModule.java", AbstractAzResourceModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule", "", "", "", "void"), 79);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourcesFromAzure", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule", "", "", "", "java.util.stream.Stream"), 374);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourceFromAzure", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule", "java.lang.String:java.lang.String", "name:resourceGroup", "", "java.lang.Object"), 389);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule", "java.lang.String", "resourceId", "", "void"), 414);
    }
}

