/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationBundle;
import com.microsoft.azure.toolkit.lib.common.operation.Operation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationBase;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.ExpressionUtils;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.MethodInvocation;
import java.util.Arrays;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;

public class MethodOperation
extends OperationBase<Object> {
    private Operation<?> parent;
    private final MethodInvocation invocation;

    public String toString() {
        AzureOperation annotation = this.invocation.getAnnotation(AzureOperation.class);
        return String.format("{name:'%s', method:%s}", annotation.name(), this.invocation.getMethod().getName());
    }

    @Override
    @Nonnull
    public String getName() {
        AzureOperation annotation = this.invocation.getAnnotation(AzureOperation.class);
        return annotation.name();
    }

    @Override
    public Callable<Object> getBody() {
        return this.invocation::invoke;
    }

    @Override
    @Nonnull
    public String getType() {
        AzureOperation annotation = this.invocation.getAnnotation(AzureOperation.class);
        return annotation.type().name();
    }

    @Override
    public AzureString getTitle() {
        AzureOperation annotation = this.invocation.getAnnotation(AzureOperation.class);
        String name = annotation.name();
        String[] params = (String[])Arrays.stream(annotation.params()).map(e -> ExpressionUtils.interpret(e, this.invocation)).toArray(String[]::new);
        return AzureOperationBundle.title(name, params);
    }

    @Override
    public Operation<?> getParent() {
        return this.parent;
    }

    public MethodInvocation getInvocation() {
        return this.invocation;
    }

    public MethodOperation(MethodInvocation invocation) {
        this.invocation = invocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodOperation)) {
            return false;
        }
        MethodOperation other = (MethodOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MethodInvocation this$invocation = this.getInvocation();
        MethodInvocation other$invocation = other.getInvocation();
        return !(this$invocation == null ? other$invocation != null : !((Object)this$invocation).equals(other$invocation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodOperation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MethodInvocation $invocation = this.getInvocation();
        result = result * 59 + ($invocation == null ? 43 : ((Object)$invocation).hashCode());
        return result;
    }

    @Override
    public void setParent(Operation<?> parent) {
        this.parent = parent;
    }
}

