/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.models.ResourceGroups;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft;
import com.microsoft.azure.toolkit.lib.resource.ResourcesServiceSubscription;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ResourceGroupModule
extends AbstractAzResourceModule<ResourceGroup, ResourcesServiceSubscription, com.azure.resourcemanager.resources.models.ResourceGroup> {
    public static final String NAME = "resourceGroups";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public ResourceGroupModule(@Nonnull ResourcesServiceSubscription parent) {
        super(NAME, parent);
    }

    @Nonnull
    @AzureOperation(name="group.create.rg", params={"name"}, type=AzureOperation.Type.SERVICE)
    public com.microsoft.azure.toolkit.lib.common.model.ResourceGroup createResourceGroupIfNotExist(@Nonnull String name, @Nonnull Region region) {
        String string = name;
        Region region2 = region;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)region2);
        try {
            com.microsoft.azure.toolkit.lib.common.model.ResourceGroup resourceGroup;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceGroup group = (ResourceGroup)this.getOrDraft(name, name);
            if (group instanceof ResourceGroupDraft && !group.exists()) {
                ((ResourceGroupDraft)group).setRegion(region);
                resourceGroup = ((ResourceGroup)((ResourceGroupDraft)group).createIfNotExist()).toPojo();
            } else {
                resourceGroup = group.toPojo();
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return resourceGroup;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    public ResourceGroups getClient() {
        return Optional.ofNullable((ResourceManager)((ResourcesServiceSubscription)this.parent).getRemote()).map(ResourceManager::resourceGroups).orElse(null);
    }

    public boolean exists(String resourceName) {
        return Optional.ofNullable(this.getClient()).map(c -> c.contain(resourceName)).orElse(false);
    }

    @Nonnull
    @AzureOperation(name="resource.draft_for_create.resource|type", params={"name", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected ResourceGroupDraft newDraftForCreate(@Nonnull String name, @Nonnull String resourceGroupName) {
        String string = name;
        String string2 = resourceGroupName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceGroupDraft resourceGroupDraft = new ResourceGroupDraft(name, resourceGroupName, this);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return resourceGroupDraft;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="resource.draft_for_update.resource|type", params={"origin.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected ResourceGroupDraft newDraftForUpdate(@Nonnull ResourceGroup origin) {
        ResourceGroup resourceGroup = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)resourceGroup);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceGroupDraft resourceGroupDraft = new ResourceGroupDraft(origin);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return resourceGroupDraft;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nonnull
    protected ResourceGroup newResource(@Nonnull com.azure.resourcemanager.resources.models.ResourceGroup r) {
        return new ResourceGroup(r, this);
    }

    @Override
    @Nonnull
    protected ResourceGroup newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new ResourceGroup(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Override
    @Nonnull
    public String getResourceTypeName() {
        return "Resource group";
    }

    static {
        ResourceGroupModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ResourceGroupModule.java", ResourceGroupModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceGroupIfNotExist", "com.microsoft.azure.toolkit.lib.resource.ResourceGroupModule", "java.lang.String:com.microsoft.azure.toolkit.lib.common.model.Region", "name:region", "", "com.microsoft.azure.toolkit.lib.common.model.ResourceGroup"), 31);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "newDraftForCreate", "com.microsoft.azure.toolkit.lib.resource.ResourceGroupModule", "java.lang.String:java.lang.String", "name:resourceGroupName", "", "com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft"), 54);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "newDraftForUpdate", "com.microsoft.azure.toolkit.lib.resource.ResourceGroupModule", "com.microsoft.azure.toolkit.lib.resource.ResourceGroup", "origin", "", "com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft"), 65);
    }
}

