/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.MethodOperation;
import com.microsoft.azure.toolkit.lib.common.operation.Operation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationException;
import com.microsoft.azure.toolkit.lib.common.operation.OperationManager;
import com.microsoft.azure.toolkit.lib.common.operation.OperationThreadContext;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemeter;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.MethodInvocation;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public final class AzureOperationAspect {
    private static final Logger log = Logger.getLogger(AzureOperationAspect.class.getName());
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ AzureOperationAspect ajc$perSingletonInstance;

    @Pointcut(value="execution(@com.microsoft.azure.toolkit.lib.common.operation.AzureOperation * *..*.*(..))")
    public void operation() {
    }

    @Before(value="operation()")
    public void beforeEnter(JoinPoint point) {
        Operation operation = AzureOperationAspect.toOperation(point);
        Object source = point.getThis();
        AzureOperationAspect.beforeEnter(operation, source);
    }

    @AfterReturning(value="operation()")
    public void afterReturning(JoinPoint point) {
        Operation current = AzureOperationAspect.toOperation(point);
        Object source = point.getThis();
        AzureOperationAspect.afterReturning(current, source);
    }

    @AfterThrowing(pointcut="operation()", throwing="e")
    public void afterThrowing(JoinPoint point, Throwable e) throws Throwable {
        Operation current = AzureOperationAspect.toOperation(point);
        Object source = point.getThis();
        AzureOperationAspect.afterThrowing(e, current, source);
    }

    public static void beforeEnter(Operation operation, Object source) {
        if (source instanceof AzResourceModule) {
            operation.getContext().setTelemetryProperty("resourceType", ((AzResourceModule)source).getFullResourceType());
            operation.getContext().setTelemetryProperty("subscriptionId", ((AzResourceModule)source).getSubscriptionId());
        } else if (source instanceof AzResource) {
            operation.getContext().setTelemetryProperty("resourceType", ((AzResource)source).getFullResourceType());
            operation.getContext().setTelemetryProperty("subscriptionId", ((AzResource)source).getSubscriptionId());
        }
        AzureTelemeter.beforeEnter(operation);
        OperationManager.getInstance().fireBeforeEnter(operation, source);
        OperationThreadContext.current().pushOperation(operation);
    }

    public static void afterReturning(Operation current, Object source) {
        Operation operation = OperationThreadContext.current().popOperation();
        assert (Objects.nonNull(operation) && Objects.equals(current, operation)) : String.format("popped operation[%s] is not the exiting operation[%s]", current, operation);
        OperationManager.getInstance().fireAfterReturning(operation, source);
        AzureTelemeter.afterExit(operation);
    }

    public static void afterThrowing(Throwable e, Operation current, Object source) throws Throwable {
        Operation operation = OperationThreadContext.current().popOperation();
        assert (Objects.nonNull(operation) && Objects.equals(current, operation)) : String.format("popped operation[%s] is not the operation[%s] throwing exception", current, operation);
        if (e instanceof OperationException) {
            throw e;
        }
        OperationManager.getInstance().fireAfterThrowing(e, operation, source);
        AzureTelemeter.onError(operation, e);
        if (e instanceof Exception && !(e instanceof RuntimeException)) {
            throw e;
        }
        throw new OperationException(operation, e);
    }

    public static <T> T execute(Operation operation, Object source) throws Throwable {
        Callable<?> body = operation.getBody();
        try {
            AzureOperationAspect.beforeEnter(operation, source);
            Object result = body.call();
            AzureOperationAspect.afterReturning(operation, source);
            return (T)result;
        }
        catch (Throwable e) {
            AzureOperationAspect.afterThrowing(e, operation, source);
            throw e;
        }
    }

    private static Operation toOperation(JoinPoint point) {
        return new MethodOperation(MethodInvocation.from(point));
    }

    static {
        try {
            AzureOperationAspect.ajc$perSingletonInstance = new AzureOperationAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static AzureOperationAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

