/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.Operation;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.io.InterruptedIOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationThreadContext {
    private static final Logger log = LoggerFactory.getLogger(OperationThreadContext.class);
    private static final ThreadLocal<OperationThreadContext> context = new ThreadLocal();
    protected long threadId = -1L;
    @Nullable
    protected Operation operation;
    @Nullable
    protected OperationThreadContext parent;

    private OperationThreadContext(@Nullable OperationThreadContext parent) {
        this.setParent(parent);
    }

    private synchronized void setParent(@Nullable OperationThreadContext parent) {
        if (!Objects.equals(this.parent, parent)) {
            this.parent = parent;
            this.operation = Optional.ofNullable(parent).map(p -> p.operation).orElse(null);
        }
    }

    @Nonnull
    public static OperationThreadContext current() {
        OperationThreadContext ctxNode = context.get();
        if (Objects.isNull(ctxNode)) {
            ctxNode = new OperationThreadContext(null);
            context.set(ctxNode);
        }
        return ctxNode;
    }

    @Nullable
    public Operation currentOperation() {
        return this.operation;
    }

    synchronized void pushOperation(Operation operation) {
        if (Objects.isNull(this.parent) && Objects.isNull(this.operation)) {
            log.debug(String.format("orphan context[%s] is setup", this));
        }
        operation.setParent(this.operation);
        this.operation = operation;
    }

    @Nullable
    synchronized Operation popOperation() {
        Operation popped = this.operation;
        if (popped == null) {
            log.warn("popped operation is null");
            return null;
        }
        assert (popped != null) : "popped operation is null";
        this.operation = popped.getParent();
        if (Objects.isNull(this.parent) && Objects.isNull(this.operation)) {
            context.remove();
            log.debug(String.format("orphan context[%s] is disposed", this));
        }
        return popped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable runnable) {
        try {
            this.setup();
            runnable.run();
        }
        catch (Throwable throwable) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)throwable);
            if (!(rootCause instanceof InterruptedIOException) && !(rootCause instanceof InterruptedException)) {
                AzureMessager.getMessager().error(throwable);
            }
        }
        finally {
            this.dispose();
        }
    }

    @Nonnull
    public OperationThreadContext derive() {
        long threadId = Thread.currentThread().getId();
        OperationThreadContext current = OperationThreadContext.current();
        assert (this == current) : String.format("[threadId:%s] deriving context from context[%s] in context[%s].", threadId, this, current);
        this.threadId = this.threadId > 0L ? this.threadId : threadId;
        return new OperationThreadContext(this);
    }

    private synchronized void setup() {
        OperationThreadContext current = OperationThreadContext.current();
        long threadId = Thread.currentThread().getId();
        assert (current.threadId == -1L || current.threadId == threadId) : String.format("[threadId:%s] illegal thread context[%s]", threadId, current);
        this.threadId = threadId;
        if (current.threadId != -1L) {
            this.setParent(current);
        }
        context.set(this);
    }

    private synchronized void dispose() {
        OperationThreadContext current = OperationThreadContext.current();
        long threadId = Thread.currentThread().getId();
        assert (this == current && this.threadId == threadId) : String.format("[threadId:%s] disposing context[%s] in context[%s].", threadId, this, current);
        OperationThreadContext ancestorContext = this.getAliveAncestor(current);
        if (this.parent == null || this.threadId != this.parent.threadId || Objects.isNull(ancestorContext)) {
            context.get().resetThreadId();
            context.remove();
        } else {
            context.get().resetThreadId();
            context.set(ancestorContext);
        }
    }

    private void resetThreadId() {
        this.threadId = -1L;
    }

    private OperationThreadContext getAliveAncestor(OperationThreadContext currentContext) {
        OperationThreadContext loopContext = currentContext.parent;
        while (Objects.nonNull(loopContext)) {
            if (loopContext.threadId != -1L) {
                return loopContext;
            }
            loopContext = loopContext.parent;
        }
        return null;
    }

    public String getId() {
        return Utils.getId(this);
    }

    public String toString() {
        String id = this.getId();
        String prId = Optional.ofNullable(this.parent).map(OperationThreadContext::getId).orElse("/");
        return String.format("{id: %s, threadId:%s, parent:%s}", id, this.threadId, prId);
    }

    @Nullable
    public OperationThreadContext getParent() {
        return this.parent;
    }
}

