/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;

public class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static <T> T deepCopyWithJson(T source) {
        return (T)JsonUtils.fromJson(JsonUtils.toJson(source), source.getClass());
    }

    public static void writeToJsonFile(File targetFile, Object json) throws IOException {
        try (FileWriter writer = new FileWriter(targetFile);){
            MAPPER.writeValue((Writer)writer, json);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T readFromJsonFile(File target, Class<T> clazz) {
        try (FileInputStream fis = new FileInputStream(target);){
            Object object;
            try (InputStreamReader isr = new InputStreamReader(fis);){
                object = MAPPER.readValue((Reader)isr, clazz);
            }
            return (T)object;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)MAPPER.readValue(json, clazz);
    }

    public static <T> T fromJson(String json, TypeReference<T> type) {
        return (T)MAPPER.readValue(json, type);
    }

    public static String toJson(Object src) {
        return MAPPER.writeValueAsString(src);
    }
}

