/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupModule;
import com.microsoft.azure.toolkit.lib.resource.ResourcesServiceSubscription;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ResourceGroupDraft
extends ResourceGroup
implements AzResource.Draft<ResourceGroup, com.azure.resourcemanager.resources.models.ResourceGroup> {
    private static final String CREATE_NEW_RESOURCE_GROUP_KEY = "createNewResourceGroup";
    @Nullable
    private final ResourceGroup origin;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    ResourceGroupDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull ResourceGroupModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    ResourceGroupDraft(@Nonnull ResourceGroup origin) {
        super(origin);
        this.origin = origin;
    }

    @Override
    public void reset() {
        this.config = null;
    }

    @Override
    @Nonnull
    @AzureOperation(name="azure/arm.create_group.rg", params={"this.getName()"})
    public com.azure.resourcemanager.resources.models.ResourceGroup createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            OperationContext.action().setTelemetryProperty(CREATE_NEW_RESOURCE_GROUP_KEY, String.valueOf(true));
            String name = this.getName();
            Region region = this.getRegion();
            if (Objects.isNull(region)) {
                throw new AzureToolkitRuntimeException("'region' is required to create resource group.");
            }
            ResourceManager manager = Objects.requireNonNull((ResourceManager)((ResourcesServiceSubscription)this.getParent()).getRemote());
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format("Start creating Resource Group({0}) in region ({1})...", name, region.getLabel()));
            com.azure.resourcemanager.resources.models.ResourceGroup group = (com.azure.resourcemanager.resources.models.ResourceGroup)((ResourceGroup.DefinitionStages.WithCreate)((ResourceGroup.DefinitionStages.Blank)manager.resourceGroups().define(name)).withRegion(region.getName())).create();
            messager.success(AzureString.format("Resource Group({0}) is successfully created.", name));
            com.azure.resourcemanager.resources.models.ResourceGroup resourceGroup = group;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return resourceGroup;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nonnull
    @AzureOperation(name="azure/arm.update_group.rg", params={"this.getName()"})
    public com.azure.resourcemanager.resources.models.ResourceGroup updateResourceInAzure(@Nonnull com.azure.resourcemanager.resources.models.ResourceGroup origin) {
        com.azure.resourcemanager.resources.models.ResourceGroup resourceGroup = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)resourceGroup);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            throw new AzureToolkitRuntimeException("not supported");
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    public void setRegion(@Nonnull Region region) {
        this.ensureConfig().setRegion(region);
    }

    @Override
    @Nullable
    public Region getRegion() {
        return Optional.ofNullable(this.config).map(Config::getRegion).orElseGet(() -> super.getRegion());
    }

    @Override
    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || Objects.isNull(this.config.getRegion()) || Objects.equals(this.config.getRegion(), super.getRegion());
        return !notModified;
    }

    @Override
    @Nullable
    public ResourceGroup getOrigin() {
        return this.origin;
    }

    static {
        ResourceGroupDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ResourceGroupDraft.java", ResourceGroupDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft", "", "", "", "com.azure.resourcemanager.resources.models.ResourceGroup"), 53);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft", "com.azure.resourcemanager.resources.models.ResourceGroup", "origin", "", "com.azure.resourcemanager.resources.models.ResourceGroup"), 72);
    }

    private static class Config {
        private Region region;

        public Region getRegion() {
            return this.region;
        }

        public void setRegion(Region region) {
            this.region = region;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Region this$region = this.getRegion();
            Region other$region = other.getRegion();
            return !(this$region == null ? other$region != null : !((Object)this$region).equals(other$region));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Region $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : ((Object)$region).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceGroupDraft.Config(region=" + this.getRegion() + ")";
        }
    }
}

