/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.monitor;

import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.models.Workspace;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsServiceWorkspaceSubscription;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspace;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceModule;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class LogAnalyticsWorkspaceDraft
extends LogAnalyticsWorkspace
implements AzResource.Draft<LogAnalyticsWorkspace, Workspace> {
    private static final String START_CREATING_LOG_ANALYTICS_WORKSPACE = "Start creating Log Analytics workspace ({0})...";
    private static final String REGION_IS_REQUIRED = "'region' is required to create Log Analytics workspace.";
    private static final String APPLICATION_INSIGHTS_CREATED = "Log Analytics workspace ({0}) is successfully created.";
    @Nullable
    private Region region;
    @Nullable
    private final LogAnalyticsWorkspace origin;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected LogAnalyticsWorkspaceDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull LogAnalyticsWorkspaceModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    protected LogAnalyticsWorkspaceDraft(@Nonnull LogAnalyticsWorkspace origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.region = null;
    }

    @Nonnull
    @AzureOperation(name="azure/workspace.create_log_analytics_workspace.workspace", params={"this.getName()"})
    public Workspace createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (Objects.isNull(this.region)) {
                throw new AzureToolkitRuntimeException(REGION_IS_REQUIRED);
            }
            LogAnalyticsManager manager = Objects.requireNonNull((LogAnalyticsManager)((LogAnalyticsServiceWorkspaceSubscription)this.getParent()).getRemote());
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)START_CREATING_LOG_ANALYTICS_WORKSPACE, (Object[])new Object[]{this.getName()}));
            Workspace workspace = manager.workspaces().define(this.getName()).withRegion(this.region.getName()).withExistingResourceGroup(this.getResourceGroupName()).create();
            messager.success(AzureString.format((String)APPLICATION_INSIGHTS_CREATED, (Object[])new Object[]{this.getName()}));
            Workspace workspace2 = workspace;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return workspace2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/workspace.update_log_analytics_workspace.workspace", params={"this.getName()"})
    public Workspace updateResourceInAzure(@Nonnull Workspace origin) {
        Workspace workspace = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)workspace);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            throw new AzureToolkitRuntimeException("not supported");
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nullable
    public Region getRegion() {
        return Optional.ofNullable(this.region).orElseGet(() -> super.getRegion());
    }

    public boolean isModified() {
        return this.region != null && !Objects.equals(this.region, this.origin.getRegion());
    }

    public void setRegion(@Nullable Region region) {
        this.region = region;
    }

    @Nullable
    public LogAnalyticsWorkspace getOrigin() {
        return this.origin;
    }

    static {
        LogAnalyticsWorkspaceDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LogAnalyticsWorkspaceDraft.java", LogAnalyticsWorkspaceDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceDraft", "", "", "", "com.azure.resourcemanager.loganalytics.models.Workspace"), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceDraft", "com.azure.resourcemanager.loganalytics.models.Workspace", "origin", "", "com.azure.resourcemanager.loganalytics.models.Workspace"), 70);
    }
}

