/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.models.PersistentDisk;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Startable;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentModule;
import com.microsoft.azure.toolkit.lib.springcloud.model.SpringCloudPersistentDisk;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class SpringCloudApp
extends AbstractAzResource<SpringCloudApp, SpringCloudCluster, SpringApp>
implements Startable,
Deletable {
    @Nonnull
    private final SpringCloudDeploymentModule deploymentModule;
    @Nullable
    private SpringCloudDeployment activeDeployment = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    protected SpringCloudApp(@Nonnull String name, @Nonnull SpringCloudAppModule module) {
        super(name, (AbstractAzResourceModule)module);
        this.deploymentModule = new SpringCloudDeploymentModule(this);
    }

    protected SpringCloudApp(@Nonnull SpringCloudApp origin) {
        super((AbstractAzResource)origin);
        this.deploymentModule = origin.deploymentModule;
        this.activeDeployment = origin.activeDeployment;
    }

    protected SpringCloudApp(@Nonnull SpringApp remote, @Nonnull SpringCloudAppModule module) {
        super(remote.name(), (AbstractAzResourceModule)module);
        this.deploymentModule = new SpringCloudDeploymentModule(this);
    }

    protected void updateAdditionalProperties(SpringApp newRemote, SpringApp oldRemote) {
        super.updateAdditionalProperties((Object)newRemote, (Object)oldRemote);
        this.activeDeployment = Optional.ofNullable(newRemote).map(SpringApp::activeDeploymentName).map(name -> (SpringCloudDeployment)this.deployments().get((String)name, this.getResourceGroupName())).orElse(null);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.deploymentModule);
    }

    @Nonnull
    public String loadStatus(@Nonnull SpringApp remote) {
        SpringCloudDeployment activeDeployment = this.getActiveDeployment();
        if (Objects.isNull((Object)activeDeployment)) {
            return "Inactive";
        }
        return activeDeployment.getStatus();
    }

    @Nonnull
    public SpringCloudDeploymentModule deployments() {
        return this.deploymentModule;
    }

    @AzureOperation(name="azure/resource.start_resource.resource", params={"this.name()"})
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> Objects.requireNonNull(this.getActiveDeployment()).start(), "Starting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/resource.stop_resource.resource", params={"this.name()"})
    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> Objects.requireNonNull(this.getActiveDeployment()).stop(), "Stopping");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/resource.restart_resource.resource", params={"this.name()"})
    public void restart() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> Objects.requireNonNull(this.getActiveDeployment()).restart(), "Restarting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public boolean isPublicEndpointEnabled() {
        if (Objects.nonNull(this.getRemote(new boolean[0]))) {
            return ((SpringApp)this.getRemote(new boolean[0])).isPublic();
        }
        return false;
    }

    @Nullable
    public synchronized String getActiveDeploymentName() {
        return Optional.ofNullable(this.getActiveDeployment()).map(AbstractAzResource::getName).orElse(null);
    }

    @Nullable
    public SpringCloudDeployment getActiveDeployment() {
        return this.remoteOptional(new boolean[]{true}).map(r -> this.activeDeployment).orElse(null);
    }

    @Nullable
    public String getApplicationUrl() {
        String url = Optional.ofNullable((SpringApp)this.getRemote(new boolean[0])).map(SpringApp::url).orElse(null);
        return StringUtils.isBlank((CharSequence)url) || url.equalsIgnoreCase("None") ? null : url;
    }

    @Nullable
    public String getTestUrl() {
        return Optional.ofNullable((SpringApp)this.getRemote(new boolean[0])).map(SpringApp::activeDeploymentName).map(d -> {
            String endpoint = ((SpringService)((SpringApp)this.getRemote(new boolean[0])).parent()).listTestKeys().primaryTestEndpoint();
            return String.format("%s/%s/%s", endpoint, this.getName(), d);
        }).orElse(null);
    }

    @Nullable
    public String getLogStreamingEndpoint(String instanceName) {
        return Optional.ofNullable((SpringApp)this.getRemote(new boolean[0])).map(SpringApp::activeDeploymentName).map(d -> {
            String endpoint = ((SpringService)((SpringApp)this.getRemote(new boolean[0])).parent()).listTestKeys().primaryTestEndpoint();
            return String.format("%s/api/logstream/apps/%s/instances/%s", endpoint.replace(".test", ""), this.getName(), instanceName);
        }).orElse(null);
    }

    @Nullable
    public SpringCloudPersistentDisk getPersistentDisk() {
        PersistentDisk disk = Optional.ofNullable((SpringApp)this.getRemote(new boolean[0])).map(SpringApp::persistentDisk).orElse(null);
        return Optional.ofNullable(disk).filter(d -> d.sizeInGB() > 0).map(d -> SpringCloudPersistentDisk.builder().sizeInGB(disk.sizeInGB()).mountPath(disk.mountPath()).usedInGB(disk.usedInGB()).build()).orElse(null);
    }

    public boolean isPersistentDiskEnabled() {
        return Objects.nonNull(this.getPersistentDisk());
    }

    @Nonnull
    public SpringCloudDeploymentModule getDeploymentModule() {
        return this.deploymentModule;
    }

    static {
        SpringCloudApp.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpringCloudApp.java", SpringCloudApp.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp", "", "", "", "void"), 82);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp", "", "", "", "void"), 87);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restart", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp", "", "", "", "void"), 92);
    }
}

