/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.models.DeploymentInstance;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppInstanceModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class SpringCloudAppInstance
extends AbstractAzResource<SpringCloudAppInstance, SpringCloudDeployment, DeploymentInstance> {
    private static final String REMOTE_URL_TEMPLATE = "https://%s/api/remoteDebugging/apps/%s/deployments/%s/instances/%s?port=%s";

    protected SpringCloudAppInstance(@NotNull String name, @NotNull SpringCloudAppInstanceModule module) {
        super(name, (AbstractAzResourceModule)module);
    }

    protected SpringCloudAppInstance(@Nonnull DeploymentInstance remote, @Nonnull SpringCloudAppInstanceModule module) {
        super(remote.name(), (AbstractAzResourceModule)module);
    }

    @NotNull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @NotNull
    public String loadStatus(@NotNull DeploymentInstance remote) {
        return remote.status();
    }

    public String getDiscoveryStatus() {
        DeploymentInstance deploymentInstance = (DeploymentInstance)this.getRemote(new boolean[0]);
        if (Objects.nonNull(deploymentInstance)) {
            return deploymentInstance.discoveryStatus();
        }
        return "Unknown";
    }

    public String getRemoteDebuggingUrl() {
        SpringCloudApp app = (SpringCloudApp)((SpringCloudDeployment)this.getParent()).getParent();
        return String.format(REMOTE_URL_TEMPLATE, ((SpringCloudCluster)app.getParent()).getFqdn(), app.getName(), ((SpringCloudDeployment)this.getParent()).getName(), this.getName(), ((SpringCloudDeployment)this.getParent()).getRemoteDebuggingPort());
    }
}

