/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud.model;

import java.util.Objects;

public class SpringCloudPersistentDisk {
    private final Integer sizeInGB;
    private final Integer usedInGB;
    private final String mountPath;

    public String toString() {
        if (this.sizeInGB > 0) {
            String value = String.format("Path: %s, Size: %d GB", this.mountPath, this.sizeInGB);
            if (Objects.nonNull(this.usedInGB)) {
                value = value + String.format(", Used: %d GB", this.usedInGB);
            }
            return value;
        }
        return "---";
    }

    SpringCloudPersistentDisk(Integer sizeInGB, Integer usedInGB, String mountPath) {
        this.sizeInGB = sizeInGB;
        this.usedInGB = usedInGB;
        this.mountPath = mountPath;
    }

    public static SpringCloudPersistentDiskBuilder builder() {
        return new SpringCloudPersistentDiskBuilder();
    }

    public Integer getSizeInGB() {
        return this.sizeInGB;
    }

    public Integer getUsedInGB() {
        return this.usedInGB;
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringCloudPersistentDisk)) {
            return false;
        }
        SpringCloudPersistentDisk other = (SpringCloudPersistentDisk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$sizeInGB = this.getSizeInGB();
        Integer other$sizeInGB = other.getSizeInGB();
        if (this$sizeInGB == null ? other$sizeInGB != null : !((Object)this$sizeInGB).equals(other$sizeInGB)) {
            return false;
        }
        Integer this$usedInGB = this.getUsedInGB();
        Integer other$usedInGB = other.getUsedInGB();
        if (this$usedInGB == null ? other$usedInGB != null : !((Object)this$usedInGB).equals(other$usedInGB)) {
            return false;
        }
        String this$mountPath = this.getMountPath();
        String other$mountPath = other.getMountPath();
        return !(this$mountPath == null ? other$mountPath != null : !this$mountPath.equals(other$mountPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpringCloudPersistentDisk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sizeInGB = this.getSizeInGB();
        result = result * 59 + ($sizeInGB == null ? 43 : ((Object)$sizeInGB).hashCode());
        Integer $usedInGB = this.getUsedInGB();
        result = result * 59 + ($usedInGB == null ? 43 : ((Object)$usedInGB).hashCode());
        String $mountPath = this.getMountPath();
        result = result * 59 + ($mountPath == null ? 43 : $mountPath.hashCode());
        return result;
    }

    public static class SpringCloudPersistentDiskBuilder {
        private Integer sizeInGB;
        private Integer usedInGB;
        private String mountPath;

        SpringCloudPersistentDiskBuilder() {
        }

        public SpringCloudPersistentDiskBuilder sizeInGB(Integer sizeInGB) {
            this.sizeInGB = sizeInGB;
            return this;
        }

        public SpringCloudPersistentDiskBuilder usedInGB(Integer usedInGB) {
            this.usedInGB = usedInGB;
            return this;
        }

        public SpringCloudPersistentDiskBuilder mountPath(String mountPath) {
            this.mountPath = mountPath;
            return this;
        }

        public SpringCloudPersistentDisk build() {
            return new SpringCloudPersistentDisk(this.sizeInGB, this.usedInGB, this.mountPath);
        }

        public String toString() {
            return "SpringCloudPersistentDisk.SpringCloudPersistentDiskBuilder(sizeInGB=" + this.sizeInGB + ", usedInGB=" + this.usedInGB + ", mountPath=" + this.mountPath + ")";
        }
    }
}

