/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.applicationinsights;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ApplicationInsightsComponent;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ApplicationType;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.InsightsManager;
import com.microsoft.azure.management.resources.Provider;
import com.microsoft.azure.management.resources.ResourceGroup;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;

public class ApplicationInsightsManager {
    private static final String MICROSOFT_INSIGHTS = "microsoft.insights";
    private static final String REGISTERED = "Registered";
    private Azure azure;
    private InsightsManager insightsManager;

    public ApplicationInsightsManager(AzureTokenCredentials tokenCredentials, String subscriptionId, String userAgent) {
        this.azure = ((Azure.Configurable)Azure.configure().withUserAgent(userAgent)).authenticate(tokenCredentials).withSubscription(subscriptionId);
        this.insightsManager = ((InsightsManager.Configurable)InsightsManager.configure().withUserAgent(userAgent)).authenticate(tokenCredentials, subscriptionId);
    }

    public ApplicationInsightsComponent getApplicationInsightsInstance(String resourceGroup, String name) {
        try {
            return (ApplicationInsightsComponent)this.insightsManager.components().getByResourceGroup(resourceGroup, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ApplicationInsightsComponent createApplicationInsights(String resourceGroup, String name, String location) throws AzureExecutionException {
        this.registerResourceProvider();
        if (!this.azure.resourceGroups().contain(resourceGroup)) {
            ((ResourceGroup.DefinitionStages.WithCreate)((ResourceGroup.DefinitionStages.Blank)this.azure.resourceGroups().define(resourceGroup)).withRegion(location)).create();
        }
        return (ApplicationInsightsComponent)((ApplicationInsightsComponent.DefinitionStages.WithApplicationType)((ApplicationInsightsComponent.DefinitionStages.WithGroup)((ApplicationInsightsComponent.DefinitionStages.Blank)this.insightsManager.components().define(name)).withRegion(location)).withExistingResourceGroup(resourceGroup)).withApplicationType(ApplicationType.WEB).withKind("web").create();
    }

    private void registerResourceProvider() throws AzureExecutionException {
        Provider insightsProvider = (Provider)this.azure.providers().getByName(MICROSOFT_INSIGHTS);
        if (insightsProvider != null && StringUtils.equalsIgnoreCase((CharSequence)insightsProvider.registrationState(), (CharSequence)REGISTERED)) {
            return;
        }
        this.azure.providers().register(MICROSOFT_INSIGHTS);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<Provider> future = executorService.submit(() -> {
            try {
                Provider provider = null;
                do {
                    Thread.sleep(1000L);
                } while (!StringUtils.equalsIgnoreCase((CharSequence)(provider = (Provider)this.azure.providers().getByName(MICROSOFT_INSIGHTS)).registrationState(), (CharSequence)REGISTERED));
                return provider;
            }
            catch (InterruptedException e) {
                return null;
            }
        });
        try {
            future.get(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new AzureExecutionException("Failed to register provider `microsoft.insights`.");
        }
    }
}

