/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.function.model;

import com.microsoft.azure.common.Utils;
import com.microsoft.azure.management.appservice.FunctionEnvelope;
import com.microsoft.azure.management.appservice.implementation.FunctionEnvelopeInner;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FunctionResource {
    private static final String FUNCTIONS = "functions";
    private static final String SCRIPT_FILE = "scriptFile";
    private static final String ENTRY_POINT = "entryPoint";
    private static final String BINDINGS = "bindings";
    private String triggerId;
    private String functionAppId;
    private String name;
    private String scriptFile;
    private String entryPoint;
    private String triggerUrl;
    private List<BindingResource> bindingList;

    public static FunctionResource parseFunction(FunctionEnvelope functionEnvelope) {
        FunctionResource resource = new FunctionResource();
        resource.triggerId = ((FunctionEnvelopeInner)functionEnvelope.inner()).id();
        resource.name = Utils.getSegment(resource.triggerId, FUNCTIONS);
        resource.functionAppId = functionEnvelope.functionAppId();
        resource.triggerUrl = ((FunctionEnvelopeInner)functionEnvelope.inner()).invokeUrlTemplate();
        Object config = functionEnvelope.config();
        if (config instanceof Map) {
            resource.scriptFile = (String)((Map)config).get(SCRIPT_FILE);
            resource.entryPoint = (String)((Map)config).get(ENTRY_POINT);
            Object bindingListObject = ((Map)config).get(BINDINGS);
            if (bindingListObject instanceof List) {
                resource.bindingList = ((List)bindingListObject).stream().filter(item -> item instanceof Map).map(map -> BindingResource.parseBinding((Map)map)).collect(Collectors.toList());
            }
        }
        return resource;
    }

    public String getName() {
        return this.name;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public String getFunctionAppId() {
        return this.functionAppId;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public List<BindingResource> getBindingList() {
        return this.bindingList;
    }

    public String getTriggerUrl() {
        return this.triggerUrl;
    }

    public BindingResource getTrigger() {
        return CollectionUtils.isEmpty(this.bindingList) ? null : (BindingResource)this.bindingList.stream().filter(bindingResource -> StringUtils.equals((CharSequence)bindingResource.direction, (CharSequence)"in") && StringUtils.containsIgnoreCase((CharSequence)bindingResource.getType(), (CharSequence)"trigger")).findFirst().orElse(null);
    }

    public static class BindingResource {
        String type;
        String direction;
        String name;
        Map<String, ?> properties;

        public static BindingResource parseBinding(Map bindingMap) {
            BindingResource resource = new BindingResource();
            resource.type = (String)bindingMap.get("type");
            resource.direction = (String)bindingMap.get("direction");
            resource.name = (String)bindingMap.get("name");
            resource.properties = bindingMap;
            return resource;
        }

        public String getType() {
            return this.type;
        }

        public String getDirection() {
            return this.direction;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, ?> getProperties() {
            return this.properties;
        }

        public Object getProperty(String key) {
            return this.properties == null ? null : this.properties.get(key);
        }
    }
}

