/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.function.handlers.runtime;

import com.microsoft.azure.arm.utils.SdkContext;
import com.microsoft.azure.common.appservice.ConfigurationSourceType;
import com.microsoft.azure.common.appservice.DeploymentSlotSetting;
import com.microsoft.azure.common.docker.IDockerCredentialProvider;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.function.configurations.FunctionExtensionVersion;
import com.microsoft.azure.common.function.configurations.RuntimeConfiguration;
import com.microsoft.azure.common.function.utils.FunctionUtils;
import com.microsoft.azure.common.handlers.runtime.BaseRuntimeHandler;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.FunctionDeploymentSlot;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.storage.StorageAccountSkuType;
import org.apache.commons.lang3.StringUtils;

public abstract class FunctionRuntimeHandler
extends BaseRuntimeHandler<FunctionApp> {
    private static final String TARGET_CONFIGURATION_SOURCE_SLOT_NOT_EXIST = "The deployment slot specified in <configurationSource> does not exist.";
    private static final String UNKNOWN_CONFIGURATION_SOURCE = "Unknown <configurationSource> value for creating deployment slot. Please use 'NEW', 'PARENT' or specify an existing slot.";
    protected FunctionExtensionVersion functionExtensionVersion;
    protected RuntimeConfiguration runtimeConfiguration;
    protected IDockerCredentialProvider dockerCredentialProvider;
    protected JavaVersion javaVersion;

    protected FunctionRuntimeHandler(Builder<?> builder) {
        super(builder);
        this.functionExtensionVersion = builder.functionExtensionVersion;
        this.runtimeConfiguration = builder.runtimeConfiguration;
        this.dockerCredentialProvider = builder.dockerCredentialProvider;
        this.javaVersion = builder.javaVersion;
    }

    public FunctionApp.DefinitionStages.WithCreate defineAppWithRuntime() throws AzureExecutionException {
        return this.defineFunctionApp().withNewStorageAccount(SdkContext.randomResourceName((String)StringUtils.replace((String)this.appName, (String)"-", (String)""), (int)20), StorageAccountSkuType.STANDARD_GRS);
    }

    public abstract FunctionApp.DefinitionStages.WithCreate defineFunctionApp() throws AzureExecutionException;

    public abstract FunctionApp.Update updateAppRuntime(FunctionApp var1) throws AzureExecutionException;

    public abstract WebAppBase.Update<FunctionDeploymentSlot> updateDeploymentSlot(FunctionDeploymentSlot var1) throws AzureExecutionException;

    public FunctionDeploymentSlot.DefinitionStages.WithCreate createDeploymentSlot(FunctionApp functionApp, DeploymentSlotSetting deploymentSlotSetting) throws AzureExecutionException {
        ConfigurationSourceType configurationSourceType = ConfigurationSourceType.fromString(deploymentSlotSetting.getConfigurationSource());
        FunctionDeploymentSlot.DefinitionStages.Blank slot = (FunctionDeploymentSlot.DefinitionStages.Blank)functionApp.deploymentSlots().define(deploymentSlotSetting.getName());
        switch (configurationSourceType) {
            case PARENT: {
                return slot.withConfigurationFromParent();
            }
            case OTHERS: {
                FunctionDeploymentSlot configurationSourceSlot = FunctionUtils.getFunctionDeploymentSlotByName(functionApp, deploymentSlotSetting.getConfigurationSource());
                if (configurationSourceSlot == null) {
                    throw new AzureExecutionException(TARGET_CONFIGURATION_SOURCE_SLOT_NOT_EXIST);
                }
                return slot.withConfigurationFromDeploymentSlot(configurationSourceSlot);
            }
        }
        throw new AzureExecutionException(UNKNOWN_CONFIGURATION_SOURCE);
    }

    @Override
    protected void changeAppServicePlan(FunctionApp app, AppServicePlan appServicePlan) throws AzureExecutionException {
        ((FunctionApp.Update)app.update()).withExistingAppServicePlan(appServicePlan).apply();
    }

    protected FunctionApp.DefinitionStages.Blank defineFunction() {
        return (FunctionApp.DefinitionStages.Blank)this.azure.appServices().functionApps().define(this.appName);
    }

    protected ResourceGroup getResourceGroup() {
        return (ResourceGroup)this.azure.resourceGroups().getByName(this.resourceGroup);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseRuntimeHandler.Builder<T> {
        protected FunctionExtensionVersion functionExtensionVersion;
        protected RuntimeConfiguration runtimeConfiguration;
        protected IDockerCredentialProvider dockerCredentialProvider;
        protected JavaVersion javaVersion;

        public T functionExtensionVersion(FunctionExtensionVersion value) {
            this.functionExtensionVersion = value;
            return (T)this.self();
        }

        public T runtime(RuntimeConfiguration value) {
            this.runtimeConfiguration = value;
            return (T)this.self();
        }

        public T dockerCredentialProvider(IDockerCredentialProvider value) {
            this.dockerCredentialProvider = value;
            return (T)this.self();
        }

        public T javaVersion(JavaVersion value) {
            this.javaVersion = value;
            return (T)this.self();
        }

        @Override
        public abstract FunctionRuntimeHandler build();

        @Override
        protected abstract T self();
    }
}

