/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.function.handlers.runtime;

import com.microsoft.azure.common.function.handlers.runtime.FunctionRuntimeHandler;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.JavaVersion;
import org.apache.commons.lang3.StringUtils;

public class WindowsFunctionRuntimeHandler
extends FunctionRuntimeHandler {
    private static final String HOST_JAVA_VERSION = "Java version of function host : %s";
    private static final String HOST_JAVA_VERSION_OFF = "Java version of function host is not initiated, set it to Java 8.";
    private static final String HOST_JAVA_VERSION_UPDATE = "Updating function host java version from %s to %s";

    protected WindowsFunctionRuntimeHandler(Builder builder) {
        super(builder);
    }

    @Override
    public FunctionApp.DefinitionStages.WithCreate defineAppWithRuntime() {
        FunctionApp.DefinitionStages.WithCreate appWithCreate;
        AppServicePlan appServicePlan = this.getAppServicePlan();
        FunctionApp.DefinitionStages.Blank functionApp = this.defineFunction();
        if (appServicePlan == null) {
            FunctionApp.DefinitionStages.NewAppServicePlanWithGroup appWithNewServicePlan = (FunctionApp.DefinitionStages.NewAppServicePlanWithGroup)functionApp.withRegion(this.region);
            appWithCreate = this.getResourceGroup() == null ? appWithNewServicePlan.withNewResourceGroup(this.resourceGroup) : appWithNewServicePlan.withExistingResourceGroup(this.resourceGroup);
            appWithCreate = this.pricingTier == null ? (StringUtils.isEmpty((CharSequence)this.servicePlanName) ? appWithCreate.withNewConsumptionPlan() : appWithCreate.withNewConsumptionPlan(this.servicePlanName)) : (StringUtils.isEmpty((CharSequence)this.servicePlanName) ? appWithCreate.withNewAppServicePlan(this.pricingTier) : appWithCreate.withNewAppServicePlan(this.servicePlanName, this.pricingTier));
        } else {
            FunctionApp.DefinitionStages.ExistingAppServicePlanWithGroup appWithExistingServicePlan = functionApp.withExistingAppServicePlan(appServicePlan);
            appWithCreate = this.getResourceGroup() == null ? (FunctionApp.DefinitionStages.WithCreate)appWithExistingServicePlan.withNewResourceGroup(this.resourceGroup) : (FunctionApp.DefinitionStages.WithCreate)appWithExistingServicePlan.withExistingResourceGroup(this.resourceGroup);
        }
        appWithCreate.withJavaVersion(this.javaVersion).withWebContainer(null);
        return appWithCreate;
    }

    @Override
    public FunctionApp.Update updateAppRuntime(FunctionApp app) {
        JavaVersion serverJavaVersion = app.javaVersion();
        FunctionApp.Update update = (FunctionApp.Update)app.update();
        if (this.javaVersion.equals((Object)serverJavaVersion)) {
            Log.info(String.format(HOST_JAVA_VERSION, serverJavaVersion));
        } else if (JavaVersion.OFF.equals((Object)serverJavaVersion)) {
            Log.info(HOST_JAVA_VERSION_OFF);
            update.withJavaVersion(this.javaVersion);
        } else if (StringUtils.isNotEmpty((CharSequence)this.runtimeConfiguration.getJavaVersion())) {
            Log.info(String.format(HOST_JAVA_VERSION_UPDATE, serverJavaVersion, this.javaVersion));
            update.withJavaVersion(this.javaVersion);
        }
        return update;
    }

    public static class Builder
    extends FunctionRuntimeHandler.Builder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WindowsFunctionRuntimeHandler build() {
            return new WindowsFunctionRuntimeHandler(this);
        }
    }
}

