/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class GetHashMac {
    private static final String MAC_REGEX = "([0-9A-Fa-f]{2}[:-]){5}[0-9A-Fa-f]{2}";
    private static final Pattern MAC_PATTERN = Pattern.compile("([0-9A-Fa-f]{2}[:-]){5}[0-9A-Fa-f]{2}");
    private static final String[] UNIX_COMMAND = new String[]{"/sbin/ifconfig -a || /sbin/ip link"};
    private static final String[] WINDOWS_COMMAND = new String[]{"getmac"};
    private static final String[] INVALID_MAC_ADDRESS = new String[]{"00:00:00:00:00:00", "ff:ff:ff:ff:ff:ff", "ac:de:48:00:11:22"};

    public static String getHashMac() {
        String ret = null;
        String rawMac = GetHashMac.getRawMac();
        String string = rawMac = GetHashMac.isValidRawMac(rawMac) ? rawMac : GetHashMac.getRawMacWithNetworkInterface();
        if (GetHashMac.isValidRawMac(rawMac)) {
            Matcher matcher = MAC_PATTERN.matcher(rawMac);
            String mac = "";
            while (matcher.find() && !GetHashMac.isValidMac(mac = matcher.group(0))) {
            }
            ret = GetHashMac.hash(mac);
        }
        return ret;
    }

    private static boolean isValidMac(String mac) {
        if (StringUtils.isEmpty((CharSequence)mac)) {
            return false;
        }
        String fixedMac = mac.replaceAll("-", ":");
        boolean isMacAddress = StringUtils.isNotEmpty((CharSequence)fixedMac) && MAC_PATTERN.matcher(fixedMac).find();
        boolean isValidMacAddress = !Arrays.stream(INVALID_MAC_ADDRESS).anyMatch(invalidMacAddress -> StringUtils.equalsIgnoreCase((CharSequence)fixedMac, (CharSequence)invalidMacAddress));
        return isMacAddress && isValidMacAddress;
    }

    private static boolean isValidRawMac(String raw) {
        return StringUtils.isNotEmpty((CharSequence)raw) && MAC_PATTERN.matcher(raw).find();
    }

    private static String getRawMac() {
        StringBuilder ret = new StringBuilder();
        try {
            String os = System.getProperty("os.name").toLowerCase();
            String[] command = StringUtils.startsWithIgnoreCase((CharSequence)os, (CharSequence)"win") ? WINDOWS_COMMAND : UNIX_COMMAND;
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.start();
            try (InputStream inputStream = process.getInputStream();
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                 BufferedReader br = new BufferedReader(inputStreamReader);){
                String tmp;
                while ((tmp = br.readLine()) != null) {
                    ret.append(tmp);
                }
            }
            if (process.waitFor() != 0) {
                throw new IOException("Command execute fail.");
            }
        }
        catch (IOException | InterruptedException ex) {
            return null;
        }
        return ret.toString();
    }

    private static String getRawMacWithNetworkInterface() {
        ArrayList<String> macSet = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.getHardwareAddress() == null) continue;
                byte[] mac = networkInterface.getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                macSet.add(sb.toString());
            }
        }
        catch (SocketException e) {
            return "";
        }
        Collections.sort(macSet);
        return StringUtils.join(macSet, (String)" ");
    }

    private static String hash(String mac) {
        String ret;
        if (StringUtils.isEmpty((CharSequence)mac)) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] bytes = mac.getBytes("UTF-8");
            md.update(bytes);
            byte[] bytesAfterDigest = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : bytesAfterDigest) {
                sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
            ret = sb.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            return null;
        }
        return ret;
    }
}

