// Generated by delombok at Wed May 06 02:05:35 UTC 2020
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotBlank;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotEmpty;

/**
 * Object containing parameters for Integrated Windows Authentication. Can be used as parameter to

 *  {@link PublicClientApplication#acquireToken(IntegratedWindowsAuthenticationParameters)}`

 *

 *  For more details, see https://aka.ms/msal4j-iwa
 */
public class IntegratedWindowsAuthenticationParameters implements IApiParameters {
    /**
     * Scopes that the application is requesting access to
     */
    @NonNull
    private Set<String> scopes;
    /**
     * Identifier of user account for which to acquire tokens for
     */
    @NonNull
    private String username;

    private static IntegratedWindowsAuthenticationParametersBuilder builder() {
        return new IntegratedWindowsAuthenticationParametersBuilder();
    }

    /**
     * Builder for {@link IntegratedWindowsAuthenticationParameters}

     * @param scopes scopes application is requesting access to

     * @param username identifier of user account for which to acquire token for. Usually in UPN format,

     *                 e.g. john.doe@contoso.com.

     * @return builder that can be used to construct IntegratedWindowsAuthenticationParameters
     */
    public static IntegratedWindowsAuthenticationParametersBuilder builder(Set<String> scopes, String username) {
        validateNotEmpty("scopes", scopes);
        validateNotBlank("username", username);
        return builder().scopes(scopes).username(username);
    }


    @java.lang.SuppressWarnings("all")
    public static class IntegratedWindowsAuthenticationParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private String username;

        @java.lang.SuppressWarnings("all")
        IntegratedWindowsAuthenticationParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public IntegratedWindowsAuthenticationParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public IntegratedWindowsAuthenticationParametersBuilder username(final String username) {
            this.username = username;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public IntegratedWindowsAuthenticationParameters build() {
            return new IntegratedWindowsAuthenticationParameters(scopes, username);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "IntegratedWindowsAuthenticationParameters.IntegratedWindowsAuthenticationParametersBuilder(scopes=" + this.scopes + ", username=" + this.username + ")";
        }
    }

    /**
     * Scopes that the application is requesting access to
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Identifier of user account for which to acquire tokens for
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public String username() {
        return this.username;
    }

    @java.beans.ConstructorProperties({"scopes", "username"})
    @java.lang.SuppressWarnings("all")
    private IntegratedWindowsAuthenticationParameters(@NonNull final Set<String> scopes, @NonNull final String username) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked @NonNull but is null");
        }
        if (username == null) {
            throw new java.lang.NullPointerException("username is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.username = username;
    }
}
