// Generated by delombok at Wed May 06 02:05:35 UTC 2020
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotEmpty;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotNull;

/**
 * Object containing parameters for silent requests. Can be used as parameter to

 * {@link PublicClientApplication#acquireTokenSilently(SilentParameters)} or to

 * {@link ConfidentialClientApplication#acquireTokenSilently(SilentParameters)}
 */
public class SilentParameters implements IApiParameters {
    @NonNull
    private Set<String> scopes;
    private IAccount account;
    private String authorityUrl;
    private boolean forceRefresh;

    private static SilentParametersBuilder builder() {
        return new SilentParametersBuilder();
    }

    /**
     * Builder for SilentParameters

     * @param scopes scopes application is requesting access to

     * @param account {@link IAccount} for which to acquire a token for

     * @return builder object that can be used to construct SilentParameters
     */
    public static SilentParametersBuilder builder(Set<String> scopes, IAccount account) {
        validateNotNull("account", account);
        validateNotEmpty("scopes", scopes);
        return builder().scopes(scopes).account(account);
    }

    /**
     * Builder for SilentParameters

     * @param scopes scopes application is requesting access to

     * @return builder object that can be used to construct SilentParameters
     */
    public static SilentParametersBuilder builder(Set<String> scopes) {
        validateNotEmpty("scopes", scopes);
        return builder().scopes(scopes);
    }


    @java.lang.SuppressWarnings("all")
    public static class SilentParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private IAccount account;
        @java.lang.SuppressWarnings("all")
        private String authorityUrl;
        @java.lang.SuppressWarnings("all")
        private boolean forceRefresh;

        @java.lang.SuppressWarnings("all")
        SilentParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public SilentParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SilentParametersBuilder account(final IAccount account) {
            this.account = account;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SilentParametersBuilder authorityUrl(final String authorityUrl) {
            this.authorityUrl = authorityUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SilentParametersBuilder forceRefresh(final boolean forceRefresh) {
            this.forceRefresh = forceRefresh;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SilentParameters build() {
            return new SilentParameters(scopes, account, authorityUrl, forceRefresh);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SilentParameters.SilentParametersBuilder(scopes=" + this.scopes + ", account=" + this.account + ", authorityUrl=" + this.authorityUrl + ", forceRefresh=" + this.forceRefresh + ")";
        }
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    @java.lang.SuppressWarnings("all")
    public IAccount account() {
        return this.account;
    }

    @java.lang.SuppressWarnings("all")
    public String authorityUrl() {
        return this.authorityUrl;
    }

    @java.lang.SuppressWarnings("all")
    public boolean forceRefresh() {
        return this.forceRefresh;
    }

    @java.beans.ConstructorProperties({"scopes", "account", "authorityUrl", "forceRefresh"})
    @java.lang.SuppressWarnings("all")
    private SilentParameters(@NonNull final Set<String> scopes, final IAccount account, final String authorityUrl, final boolean forceRefresh) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.account = account;
        this.authorityUrl = authorityUrl;
        this.forceRefresh = forceRefresh;
    }
}
