/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import com.microsoft.aad.msal4j.AuthorityType;
import com.microsoft.aad.msal4j.ClientAuthenticationPost;
import com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import com.microsoft.aad.msal4j.DeviceCodeFlowRequest;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IPublicClientApplication;
import com.microsoft.aad.msal4j.IntegratedWindowsAuthenticationParameters;
import com.microsoft.aad.msal4j.IntegratedWindowsAuthenticationRequest;
import com.microsoft.aad.msal4j.InteractiveRequest;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import com.microsoft.aad.msal4j.PublicApi;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import com.microsoft.aad.msal4j.UserNamePasswordRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.LoggerFactory;

public class PublicClientApplication
extends AbstractClientApplicationBase
implements IPublicClientApplication {
    private final ClientAuthenticationPost clientAuthentication;

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(UserNamePasswordParameters parameters) {
        ParameterValidationUtils.validateNotNull("parameters", parameters);
        UserNamePasswordRequest userNamePasswordRequest = new UserNamePasswordRequest(parameters, this, this.createRequestContext(PublicApi.ACQUIRE_TOKEN_BY_USERNAME_PASSWORD, parameters));
        return this.executeRequest(userNamePasswordRequest);
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(IntegratedWindowsAuthenticationParameters parameters) {
        ParameterValidationUtils.validateNotNull("parameters", parameters);
        IntegratedWindowsAuthenticationRequest integratedWindowsAuthenticationRequest = new IntegratedWindowsAuthenticationRequest(parameters, this, this.createRequestContext(PublicApi.ACQUIRE_TOKEN_BY_INTEGRATED_WINDOWS_AUTH, parameters));
        return this.executeRequest(integratedWindowsAuthenticationRequest);
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(DeviceCodeFlowParameters parameters) {
        if (!AuthorityType.AAD.equals((Object)this.authenticationAuthority.authorityType())) {
            throw new IllegalArgumentException("Invalid authority type. Device Flow is only supported by AAD authority");
        }
        ParameterValidationUtils.validateNotNull("parameters", parameters);
        AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference = new AtomicReference<CompletableFuture<IAuthenticationResult>>();
        DeviceCodeFlowRequest deviceCodeRequest = new DeviceCodeFlowRequest(parameters, futureReference, this, this.createRequestContext(PublicApi.ACQUIRE_TOKEN_BY_DEVICE_CODE_FLOW, parameters));
        CompletableFuture<IAuthenticationResult> future = this.executeRequest(deviceCodeRequest);
        futureReference.set(future);
        return future;
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(InteractiveRequestParameters parameters) {
        ParameterValidationUtils.validateNotNull("parameters", parameters);
        AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference = new AtomicReference<CompletableFuture<IAuthenticationResult>>();
        InteractiveRequest interactiveRequest = new InteractiveRequest(parameters, futureReference, this, this.createRequestContext(PublicApi.ACQUIRE_TOKEN_INTERACTIVE, parameters));
        CompletableFuture<IAuthenticationResult> future = this.executeRequest(interactiveRequest);
        futureReference.set(future);
        return future;
    }

    private PublicClientApplication(Builder builder) {
        super(builder);
        ParameterValidationUtils.validateNotBlank("clientId", this.clientId());
        this.log = LoggerFactory.getLogger(PublicClientApplication.class);
        this.clientAuthentication = new ClientAuthenticationPost(ClientAuthenticationMethod.NONE, new ClientID(this.clientId()));
    }

    @Override
    protected ClientAuthentication clientAuthentication() {
        return this.clientAuthentication;
    }

    public static Builder builder(String clientId) {
        return new Builder(clientId);
    }

    public static class Builder
    extends AbstractClientApplicationBase.Builder<Builder> {
        private Builder(String clientId) {
            super(clientId);
        }

        @Override
        public PublicClientApplication build() {
            return new PublicClientApplication(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

