/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config.resource;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class Connection {
    private static final String CONN_STRING_REGEXP = "Endpoint=([^;]+);Id=([^;]+);Secret=([^;]+)";
    public static final String ENDPOINT_ERR_MSG = String.format("Connection string does not follow format %s.", "Endpoint=([^;]+);Id=([^;]+);Secret=([^;]+)");
    private static final Pattern CONN_STRING_PATTERN = Pattern.compile("Endpoint=([^;]+);Id=([^;]+);Secret=([^;]+)");
    public static final String NON_EMPTY_MSG = "%s property should not be null or empty in the connection string of Azure Config Service.";
    private final String endpoint;
    private final String connectionString;
    private final String clientId;

    public Connection(String connectionString) {
        Assert.hasText((String)connectionString, (String)String.format("Connection string cannot be empty.", new Object[0]));
        Matcher matcher = CONN_STRING_PATTERN.matcher(connectionString);
        if (!matcher.find()) {
            throw new IllegalStateException(ENDPOINT_ERR_MSG);
        }
        this.endpoint = matcher.group(1);
        Assert.hasText((String)this.endpoint, (String)String.format(NON_EMPTY_MSG, "Endpoint"));
        this.connectionString = connectionString;
        this.clientId = "";
    }

    public Connection(String endpoint, String clientId) {
        this.endpoint = endpoint;
        this.clientId = clientId;
        this.connectionString = "";
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getClientId() {
        return this.clientId;
    }
}

