/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config.stores;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.ExponentialBackoff;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.data.appconfiguration.ConfigurationAsyncClient;
import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.microsoft.azure.spring.cloud.config.AppConfigurationCredentialProvider;
import com.microsoft.azure.spring.cloud.config.AppConfigurationProviderProperties;
import com.microsoft.azure.spring.cloud.config.ConfigurationClientBuilderSetup;
import com.microsoft.azure.spring.cloud.config.pipline.policies.BaseAppConfigurationPolicy;
import com.microsoft.azure.spring.cloud.config.resource.Connection;
import com.microsoft.azure.spring.cloud.config.resource.ConnectionPool;
import com.microsoft.azure.spring.cloud.config.stores.ConfigStore;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class ClientStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientStore.class);
    private AppConfigurationProviderProperties appProperties;
    private ConnectionPool pool;
    private AppConfigurationCredentialProvider tokenCredentialProvider;
    private ConfigurationClientBuilderSetup clientProvider;

    public ClientStore(AppConfigurationProviderProperties appProperties, ConnectionPool pool, AppConfigurationCredentialProvider tokenCredentialProvider, ConfigurationClientBuilderSetup clientProvider) {
        this.appProperties = appProperties;
        this.pool = pool;
        this.tokenCredentialProvider = tokenCredentialProvider;
        this.clientProvider = clientProvider;
    }

    private ConfigurationAsyncClient buildClient(String store) throws IllegalArgumentException {
        ConfigurationClientBuilder builder = this.getBuilder();
        ExponentialBackoff retryPolicy = new ExponentialBackoff(this.appProperties.getMaxRetries(), Duration.ofMillis(800L), Duration.ofSeconds(8L));
        builder = builder.addPolicy((HttpPipelinePolicy)new BaseAppConfigurationPolicy()).retryPolicy((HttpPipelinePolicy)new RetryPolicy((RetryStrategy)retryPolicy));
        TokenCredential tokenCredential = null;
        Connection connection = this.pool.get(store);
        String endpoint = connection.getEndpoint();
        if (this.tokenCredentialProvider != null) {
            tokenCredential = this.tokenCredentialProvider.getAppConfigCredential(endpoint);
        }
        if ((tokenCredential != null || connection.getClientId() != null && StringUtils.isNotEmpty((CharSequence)connection.getClientId())) && connection != null && StringUtils.isNotEmpty((CharSequence)connection.getConnectionString())) {
            throw new IllegalArgumentException("More than 1 Conncetion method was set for connecting to App Configuration.");
        }
        if (tokenCredential != null && connection != null && connection.getClientId() != null && StringUtils.isNotEmpty((CharSequence)connection.getClientId())) {
            throw new IllegalArgumentException("More than 1 Conncetion method was set for connecting to App Configuration.");
        }
        if (tokenCredential != null) {
            LOGGER.debug("Connecting to " + endpoint + " using AppConfigurationCredentialProvider.");
            builder.credential(tokenCredential);
        } else if (connection.getClientId() != null && StringUtils.isNotEmpty((CharSequence)connection.getClientId()) && connection.getEndpoint() != null) {
            LOGGER.debug("Connecting to " + endpoint + " using Client ID from configuration file.");
            ManagedIdentityCredentialBuilder micBuilder = new ManagedIdentityCredentialBuilder().clientId(connection.getClientId());
            builder.credential((TokenCredential)micBuilder.build());
        } else if (StringUtils.isNotEmpty((CharSequence)connection.getConnectionString())) {
            LOGGER.debug("Connecting to " + endpoint + " using Connecting String.");
            builder.connectionString(connection.getConnectionString());
        } else if (connection.getEndpoint() != null) {
            LOGGER.debug("Connecting to " + endpoint + " using Azure System Assigned Identity or Azure User Assigned Identity.");
            ManagedIdentityCredentialBuilder micBuilder = new ManagedIdentityCredentialBuilder();
            builder.credential((TokenCredential)micBuilder.build());
        } else {
            throw new IllegalArgumentException("No Configuration method was set for connecting to App Configuration");
        }
        builder.endpoint(endpoint);
        if (this.clientProvider != null) {
            this.clientProvider.setup(builder, endpoint);
        }
        return builder.buildAsyncClient();
    }

    public final ConfigurationSetting getRevison(SettingSelector settingSelector, String storeName) {
        ConfigurationAsyncClient client = this.buildClient(storeName);
        return (ConfigurationSetting)client.listRevisions(settingSelector).blockFirst();
    }

    public final List<ConfigurationSetting> listSettings(SettingSelector settingSelector, String storeName) throws IOException {
        ConfigurationAsyncClient client = this.buildClient(storeName);
        return (List)client.listConfigurationSettings(settingSelector).collectList().block();
    }

    public List<String> watchedKeyNames(ConfigStore store, Map<String, List<String>> storeContextsMap) {
        ArrayList<String> watchedKeys = new ArrayList<String>();
        String watchedKey = store.getWatchedKey().trim();
        List<String> contexts = storeContextsMap.get(store.getEndpoint());
        for (String context : contexts) {
            String key = this.genKey(context, watchedKey);
            if (key.contains(",") && key.contains("*")) {
                key = "*";
            }
            watchedKeys.add(key);
        }
        return watchedKeys;
    }

    public String watchedKeyNames(ConfigStore store, String context) {
        String watchedKey = store.getWatchedKey().trim();
        String watchedKeys = this.genKey(context, watchedKey);
        if (watchedKeys.contains(",") && watchedKeys.contains("*")) {
            watchedKeys = "*";
        }
        return watchedKeys;
    }

    private String genKey(@NonNull String context, @Nullable String watchedKey) {
        String trimmedWatchedKey = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{watchedKey}) ? watchedKey.trim() : "*";
        return String.format("%s%s", context, trimmedWatchedKey);
    }

    ConfigurationClientBuilder getBuilder() {
        return new ConfigurationClientBuilder();
    }
}

