/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config.stores;

import com.microsoft.azure.spring.cloud.config.resource.Connection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ConfigStore {
    private static final String EMPTY_LABEL = "\u0000";
    private static final String[] EMPTY_LABEL_ARRAY = new String[]{"\u0000"};
    private String endpoint;
    @Nullable
    @Pattern(regexp="(/[a-zA-Z0-9.\\-_]+)*")
    private @Pattern(regexp="(/[a-zA-Z0-9.\\-_]+)*") String prefix;
    private String connectionString;
    @Nullable
    private String label;
    @NotEmpty
    private String watchedKey = "*";
    private boolean failFast = true;

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getWatchedKey() {
        return this.watchedKey;
    }

    public void setWatchedKey(String watchedKey) {
        this.watchedKey = watchedKey;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    @PostConstruct
    public void validateAndInit() {
        if (StringUtils.hasText((String)this.label)) {
            Assert.isTrue((!this.label.contains("*") ? 1 : 0) != 0, (String)"Label must not contain asterisk(*).");
        }
        if (StringUtils.hasText((String)this.connectionString)) {
            String endpoint = new Connection(this.connectionString).getEndpoint();
            try {
                new URI(endpoint);
                this.endpoint = endpoint;
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Endpoint in connection string is not a valid URI.", e);
            }
        }
        Assert.isTrue((boolean)this.watchedKeyValid(this.watchedKey), (String)"Watched key can only be a single asterisk(*) or a specific key without asterisk(*)");
    }

    private boolean watchedKeyValid(String watchedKey) {
        if (!StringUtils.hasText((String)watchedKey)) {
            return false;
        }
        String trimmedKey = watchedKey.trim();
        return trimmedKey.equals("*") || !trimmedKey.contains("*");
    }

    public String[] getLabels() {
        if (!StringUtils.hasText((String)this.getLabel())) {
            return EMPTY_LABEL_ARRAY;
        }
        List<String> labels = Arrays.stream(this.getLabel().split(",")).map(label -> this.mapLabel((String)label)).distinct().collect(Collectors.toList());
        if (this.getLabel().endsWith(",")) {
            labels.add(EMPTY_LABEL);
        }
        Collections.reverse(labels);
        if (labels.isEmpty()) {
            return EMPTY_LABEL_ARRAY;
        }
        String[] t = new String[labels.size()];
        return labels.toArray(t);
    }

    private String mapLabel(String label) {
        if (label == null || label.equals("")) {
            return EMPTY_LABEL;
        }
        return label.trim();
    }
}

