/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb;

import com.azure.data.cosmos.CosmosClient;
import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.spring.data.cosmosdb.common.MacAddress;
import com.microsoft.azure.spring.data.cosmosdb.common.PropertyLoader;
import com.microsoft.azure.spring.data.cosmosdb.common.TelemetrySender;
import com.microsoft.azure.spring.data.cosmosdb.config.DocumentDBConfig;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CosmosDbFactory {
    private final DocumentDBConfig config;
    private static final boolean IS_TELEMETRY_ALLOWED = PropertyLoader.isApplicationTelemetryAllowed();
    private static final String USER_AGENT_SUFFIX = "spring-data/" + PropertyLoader.getProjectVersion();

    private String getUserAgentSuffix() {
        String suffix = ";" + USER_AGENT_SUFFIX;
        if (IS_TELEMETRY_ALLOWED) {
            suffix = suffix + ";" + MacAddress.getHashMac();
        }
        return suffix;
    }

    public CosmosDbFactory(@NonNull DocumentDBConfig config) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        this.validateConfig(config);
        this.config = config;
    }

    public CosmosClient getCosmosClient() {
        ConnectionPolicy policy = this.config.getConnectionPolicy();
        String userAgent = this.getUserAgentSuffix() + ";" + policy.getUserAgentSuffix();
        policy.setUserAgentSuffix(userAgent);
        return CosmosClient.builder().endpoint(this.config.getUri()).key(this.config.getKey()).cosmosKeyCredential(this.config.getCosmosKeyCredential()).build();
    }

    private void validateConfig(@NonNull DocumentDBConfig config) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        Assert.hasText((String)config.getUri(), (String)"cosmosdb host url should have text!");
        if (config.getCosmosKeyCredential() == null) {
            Assert.hasText((String)config.getKey(), (String)"cosmosdb host key should have text!");
        } else if (StringUtils.isEmpty((Object)config.getKey())) {
            Assert.hasText((String)config.getCosmosKeyCredential().key(), (String)"cosmosdb credential host key should have text!");
        }
        Assert.hasText((String)config.getDatabase(), (String)"cosmosdb database should have text!");
        Assert.notNull((Object)config.getConnectionPolicy(), (String)"cosmosdb connection policy should not be null!");
    }

    @PostConstruct
    private void sendTelemetry() {
        if (IS_TELEMETRY_ALLOWED) {
            TelemetrySender sender = new TelemetrySender();
            sender.send(this.getClass().getSimpleName());
        }
    }

    public DocumentDBConfig getConfig() {
        return this.config;
    }
}

