/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MacAddress {
    private static final String UNKNOWN_MAC_ADDRESS = "Unknown-Mac-Address";
    private static final String MAC_REGEX = "([0-9A-Fa-f]{2}[:-]){5}[0-9A-Fa-f]{2}";
    private static final String MAC_REGEX_ZERO = "([0]{2}[:-]){5}[0]{2}";
    private static final String HASHED_MAC_REGEX = "[0-9a-f]{64}";

    private static boolean isValidHashMacFormat(@NonNull String hashMac) {
        if (hashMac == null) {
            throw new NullPointerException("hashMac");
        }
        if (hashMac.isEmpty()) {
            return false;
        }
        return Pattern.compile(HASHED_MAC_REGEX).matcher(hashMac).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRawMac() {
        String os = System.getProperty("os.name");
        StringBuilder macBuilder = new StringBuilder();
        List<String> commands = os != null && !os.isEmpty() && os.toLowerCase(Locale.US).startsWith("win") ? Collections.singletonList("getmac") : Arrays.asList("ifconfig", "-a");
        try {
            ProcessBuilder builder = new ProcessBuilder(commands);
            Process process = builder.start();
            InputStreamReader streamReader = new InputStreamReader(process.getInputStream(), "utf-8");
            try {
                BufferedReader reader = new BufferedReader(streamReader);
                try {
                    String tmp;
                    while ((tmp = reader.readLine()) != null) {
                        macBuilder.append(tmp);
                    }
                }
                finally {
                    if (Collections.singletonList(reader).get(0) != null) {
                        reader.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(streamReader).get(0) != null) {
                    streamReader.close();
                }
            }
        }
        catch (IOException e) {
            return "";
        }
        return macBuilder.toString();
    }

    private static String getHexDigest(byte digest) {
        String hex = Integer.toString((digest & 0xFF) + 256, 16);
        return hex.substring(1);
    }

    private static String hash(@NonNull String mac) {
        if (mac == null) {
            throw new NullPointerException("mac");
        }
        if (mac.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        try {
            byte[] digestBytes;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(mac.getBytes("UTF-8"));
            for (byte digest : digestBytes = messageDigest.digest()) {
                builder.append(MacAddress.getHexDigest(digest));
            }
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            return "";
        }
        Assert.isTrue((boolean)MacAddress.isValidHashMacFormat(builder.toString()), (String)"Invalid format for HashMac");
        return builder.toString();
    }

    public static String getHashMac() {
        String rawMac = MacAddress.getRawMac();
        if (rawMac.isEmpty()) {
            return UNKNOWN_MAC_ADDRESS;
        }
        Pattern pattern = Pattern.compile(MAC_REGEX);
        Pattern patternZero = Pattern.compile(MAC_REGEX_ZERO);
        Matcher matcher = pattern.matcher(rawMac);
        String mac = "";
        while (matcher.find() && patternZero.matcher(mac = matcher.group(0)).matches()) {
        }
        String hashMac = MacAddress.hash(mac);
        if (StringUtils.hasText((String)hashMac)) {
            return hashMac;
        }
        return UNKNOWN_MAC_ADDRESS;
    }

    private MacAddress() {
    }
}

