/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.spring.data.cosmosdb.CosmosDbFactory;
import com.microsoft.azure.spring.data.cosmosdb.DocumentDbFactory;
import com.microsoft.azure.spring.data.cosmosdb.config.DocumentDBConfig;
import com.microsoft.azure.spring.data.cosmosdb.config.DocumentDbConfigurationSupport;
import com.microsoft.azure.spring.data.cosmosdb.core.DocumentDbTemplate;
import com.microsoft.azure.spring.data.cosmosdb.core.ReactiveCosmosTemplate;
import com.microsoft.azure.spring.data.cosmosdb.core.convert.MappingDocumentDbConverter;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.DocumentDbPersistentEntity;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.DocumentDbPersistentProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mapping.context.MappingContext;

@Configuration
public abstract class AbstractDocumentDbConfiguration
extends DocumentDbConfigurationSupport {
    @Qualifier(value="cosmosdbObjectMapper")
    @Autowired(required=false)
    private ObjectMapper objectMapper;

    @Bean
    public DocumentClient documentClient(DocumentDBConfig config) {
        return this.documentDbFactory(config).getDocumentClient();
    }

    @Bean
    public DocumentDbFactory documentDbFactory(DocumentDBConfig config) {
        return new DocumentDbFactory(config);
    }

    @Bean
    public CosmosDbFactory cosmosDbFactory(DocumentDBConfig config) {
        return new CosmosDbFactory(config);
    }

    @Bean
    public DocumentDbTemplate documentDbTemplate(DocumentDBConfig config) throws ClassNotFoundException {
        return new DocumentDbTemplate(this.cosmosDbFactory(config), this.mappingDocumentDbConverter(), config.getDatabase());
    }

    @Bean
    public ReactiveCosmosTemplate cosmosDbTemplate(DocumentDBConfig config) throws ClassNotFoundException {
        return new ReactiveCosmosTemplate(this.cosmosDbFactory(config), this.mappingDocumentDbConverter(), config.getDatabase());
    }

    @Bean
    public MappingDocumentDbConverter mappingDocumentDbConverter() throws ClassNotFoundException {
        return new MappingDocumentDbConverter((MappingContext<? extends DocumentDbPersistentEntity<?>, DocumentDbPersistentProperty>)this.documentDbMappingContext(), this.objectMapper);
    }
}

