/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.config;

import com.azure.data.cosmos.CosmosKeyCredential;
import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.RequestOptions;
import com.microsoft.azure.spring.data.cosmosdb.exception.DocumentDBAccessException;
import java.beans.ConstructorProperties;
import org.springframework.util.Assert;

public class DocumentDBConfig {
    private String uri;
    private String key;
    private String database;
    private ConnectionPolicy connectionPolicy;
    private ConsistencyLevel consistencyLevel;
    private boolean allowTelemetry;
    private RequestOptions requestOptions;
    private CosmosKeyCredential cosmosKeyCredential;

    public static DocumentDBConfigBuilder builder(String uri, CosmosKeyCredential cosmosKeyCredential, String database) {
        return DocumentDBConfig.defaultBuilder().uri(uri).cosmosKeyCredential(cosmosKeyCredential).database(database).connectionPolicy(ConnectionPolicy.GetDefault()).consistencyLevel(ConsistencyLevel.Session).requestOptions(new RequestOptions());
    }

    public static DocumentDBConfigBuilder builder(String uri, String key, String database) {
        return DocumentDBConfig.defaultBuilder().uri(uri).key(key).database(database).connectionPolicy(ConnectionPolicy.GetDefault()).consistencyLevel(ConsistencyLevel.Session).requestOptions(new RequestOptions());
    }

    public static DocumentDBConfigBuilder builder(String connectionString, String database) {
        Assert.hasText((String)connectionString, (String)"connection string should have text!");
        try {
            String uri = connectionString.split(";")[0].split("=")[1];
            String key = connectionString.split(";")[1].split("=")[1];
            return DocumentDBConfig.builder(uri, key, database);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DocumentDBAccessException("could not parse connection string");
        }
    }

    @ConstructorProperties(value={"uri", "key", "database", "connectionPolicy", "consistencyLevel", "allowTelemetry", "requestOptions", "cosmosKeyCredential"})
    DocumentDBConfig(String uri, String key, String database, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, boolean allowTelemetry, RequestOptions requestOptions, CosmosKeyCredential cosmosKeyCredential) {
        this.uri = uri;
        this.key = key;
        this.database = database;
        this.connectionPolicy = connectionPolicy;
        this.consistencyLevel = consistencyLevel;
        this.allowTelemetry = allowTelemetry;
        this.requestOptions = requestOptions;
        this.cosmosKeyCredential = cosmosKeyCredential;
    }

    public static DocumentDBConfigBuilder defaultBuilder() {
        return new DocumentDBConfigBuilder();
    }

    public String getUri() {
        return this.uri;
    }

    public String getKey() {
        return this.key;
    }

    public String getDatabase() {
        return this.database;
    }

    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public boolean isAllowTelemetry() {
        return this.allowTelemetry;
    }

    public RequestOptions getRequestOptions() {
        return this.requestOptions;
    }

    public CosmosKeyCredential getCosmosKeyCredential() {
        return this.cosmosKeyCredential;
    }

    public static class DocumentDBConfigBuilder {
        private String uri;
        private String key;
        private String database;
        private ConnectionPolicy connectionPolicy;
        private ConsistencyLevel consistencyLevel;
        private boolean allowTelemetry;
        private RequestOptions requestOptions;
        private CosmosKeyCredential cosmosKeyCredential;

        DocumentDBConfigBuilder() {
        }

        public DocumentDBConfigBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public DocumentDBConfigBuilder key(String key) {
            this.key = key;
            return this;
        }

        public DocumentDBConfigBuilder database(String database) {
            this.database = database;
            return this;
        }

        public DocumentDBConfigBuilder connectionPolicy(ConnectionPolicy connectionPolicy) {
            this.connectionPolicy = connectionPolicy;
            return this;
        }

        public DocumentDBConfigBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public DocumentDBConfigBuilder allowTelemetry(boolean allowTelemetry) {
            this.allowTelemetry = allowTelemetry;
            return this;
        }

        public DocumentDBConfigBuilder requestOptions(RequestOptions requestOptions) {
            this.requestOptions = requestOptions;
            return this;
        }

        public DocumentDBConfigBuilder cosmosKeyCredential(CosmosKeyCredential cosmosKeyCredential) {
            this.cosmosKeyCredential = cosmosKeyCredential;
            return this;
        }

        public DocumentDBConfig build() {
            return new DocumentDBConfig(this.uri, this.key, this.database, this.connectionPolicy, this.consistencyLevel, this.allowTelemetry, this.requestOptions, this.cosmosKeyCredential);
        }

        public String toString() {
            return "DocumentDBConfig.DocumentDBConfigBuilder(uri=" + this.uri + ", key=" + this.key + ", database=" + this.database + ", connectionPolicy=" + this.connectionPolicy + ", consistencyLevel=" + this.consistencyLevel + ", allowTelemetry=" + this.allowTelemetry + ", requestOptions=" + this.requestOptions + ", cosmosKeyCredential=" + this.cosmosKeyCredential + ")";
        }
    }
}

