/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.query;

import com.microsoft.azure.spring.data.cosmosdb.core.DocumentDbOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentDbPageRequest;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import org.springframework.data.domain.Pageable;

public interface DocumentDbQueryExecution {
    public Object execute(DocumentQuery var1, Class<?> var2, String var3);

    public static final class PagedExecution
    implements DocumentDbQueryExecution {
        private final DocumentDbOperations operations;
        private final Pageable pageable;

        public PagedExecution(DocumentDbOperations operations, Pageable pageable) {
            this.operations = operations;
            this.pageable = pageable;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String collection) {
            if (this.pageable.getPageNumber() != 0 && !(this.pageable instanceof DocumentDbPageRequest)) {
                throw new IllegalStateException("Not the first page but Pageable is not a valid DocumentDbPageRequest, requestContinuation is required for non first page request");
            }
            query.with(this.pageable);
            return this.operations.paginationQuery(query, type, collection);
        }
    }

    public static final class DeleteExecution
    implements DocumentDbQueryExecution {
        private final DocumentDbOperations operations;

        public DeleteExecution(DocumentDbOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String collection) {
            return this.operations.delete(query, type, collection);
        }
    }

    public static final class ExistsExecution
    implements DocumentDbQueryExecution {
        private final DocumentDbOperations operations;

        public ExistsExecution(DocumentDbOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String collection) {
            return this.operations.exists(query, type, collection);
        }
    }

    public static final class MultiEntityExecution
    implements DocumentDbQueryExecution {
        private final DocumentDbOperations operations;

        public MultiEntityExecution(DocumentDbOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String collection) {
            return this.operations.find(query, type, collection);
        }
    }

    public static final class CollectionExecution
    implements DocumentDbQueryExecution {
        private final DocumentDbOperations operations;

        public CollectionExecution(DocumentDbOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String collection) {
            return this.operations.getCollectionName(type);
        }
    }
}

