/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.support;

import com.azure.data.cosmos.ExcludedPath;
import com.azure.data.cosmos.IncludedPath;
import com.azure.data.cosmos.IndexingMode;
import com.azure.data.cosmos.IndexingPolicy;
import com.microsoft.azure.spring.data.cosmosdb.Constants;
import com.microsoft.azure.spring.data.cosmosdb.common.ExpressionResolver;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.Document;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.DocumentIndexingPolicy;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.PartitionKey;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.json.JSONObject;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Version;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public class CosmosEntityInformation<T, ID>
extends AbstractEntityInformation<T, ID> {
    private static final String ETAG = "_etag";
    private Field id;
    private Field partitionKeyField;
    private String containerName;
    private Integer requestUnit;
    private Integer timeToLive;
    private IndexingPolicy indexingPolicy;
    private boolean isVersioned;
    private boolean autoCreateContainer;

    public CosmosEntityInformation(Class<T> domainType) {
        super(domainType);
        this.id = this.getIdField(domainType);
        ReflectionUtils.makeAccessible((Field)this.id);
        this.containerName = this.getContainerName(domainType);
        this.partitionKeyField = this.getPartitionKeyField(domainType);
        if (this.partitionKeyField != null) {
            ReflectionUtils.makeAccessible((Field)this.partitionKeyField);
        }
        this.requestUnit = this.getRequestUnit(domainType);
        this.timeToLive = this.getTimeToLive(domainType);
        this.indexingPolicy = this.getIndexingPolicy(domainType);
        this.isVersioned = this.getIsVersioned(domainType);
        this.autoCreateContainer = this.getIsAutoCreateContainer(domainType);
    }

    public ID getId(T entity) {
        return (ID)ReflectionUtils.getField((Field)this.id, entity);
    }

    public Field getIdField() {
        return this.id;
    }

    public Class<ID> getIdType() {
        return this.id.getType();
    }

    @Deprecated
    public String getCollectionName() {
        return this.containerName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public Integer getRequestUnit() {
        return this.requestUnit;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    @NonNull
    public IndexingPolicy getIndexingPolicy() {
        return this.indexingPolicy;
    }

    public boolean isVersioned() {
        return this.isVersioned;
    }

    public String getPartitionKeyFieldName() {
        if (this.partitionKeyField == null) {
            return null;
        }
        PartitionKey partitionKey = this.partitionKeyField.getAnnotation(PartitionKey.class);
        return partitionKey.value().equals("") ? this.partitionKeyField.getName() : partitionKey.value();
    }

    public String getPartitionKeyFieldValue(T entity) {
        return this.partitionKeyField == null ? null : (String)ReflectionUtils.getField((Field)this.partitionKeyField, entity);
    }

    @Deprecated
    public boolean isAutoCreateCollection() {
        return this.autoCreateContainer;
    }

    public boolean isAutoCreateContainer() {
        return this.autoCreateContainer;
    }

    private IndexingPolicy getIndexingPolicy(Class<?> domainType) {
        IndexingPolicy policy = new IndexingPolicy();
        policy.automatic(this.getIndexingPolicyAutomatic(domainType).booleanValue());
        policy.indexingMode(this.getIndexingPolicyMode(domainType));
        policy.setIncludedPaths(this.getIndexingPolicyIncludePaths(domainType));
        policy.excludedPaths(this.getIndexingPolicyExcludePaths(domainType));
        return policy;
    }

    private Field getIdField(Class<?> domainType) {
        Field idField;
        List fields = FieldUtils.getFieldsListWithAnnotation(domainType, Id.class);
        if (fields.isEmpty()) {
            idField = ReflectionUtils.findField((Class)this.getJavaType(), (String)"id");
        } else if (fields.size() == 1) {
            idField = (Field)fields.get(0);
        } else {
            throw new IllegalArgumentException("only one field with @Id annotation!");
        }
        if (idField == null) {
            throw new IllegalArgumentException("domain should contain @Id field or field named id");
        }
        if (idField.getType() != String.class && idField.getType() != Integer.class && idField.getType() != Integer.TYPE) {
            throw new IllegalArgumentException("type of id field must be String or Integer");
        }
        return idField;
    }

    private String getContainerName(Class<?> domainType) {
        String customContainerName = domainType.getSimpleName();
        Document annotation = domainType.getAnnotation(Document.class);
        if (annotation != null && annotation.collection() != null && !annotation.collection().isEmpty()) {
            customContainerName = ExpressionResolver.resolveExpression(annotation.collection());
        }
        return customContainerName;
    }

    private Field getPartitionKeyField(Class<?> domainType) {
        Field partitionKey = null;
        List fields = FieldUtils.getFieldsListWithAnnotation(domainType, PartitionKey.class);
        if (fields.size() == 1) {
            partitionKey = (Field)fields.get(0);
        } else if (fields.size() > 1) {
            throw new IllegalArgumentException("Azure Cosmos DB supports only one partition key, only one field with @PartitionKey annotation!");
        }
        if (partitionKey != null && partitionKey.getType() != String.class) {
            throw new IllegalArgumentException("type of PartitionKey field must be String");
        }
        return partitionKey;
    }

    private Integer getRequestUnit(Class<?> domainType) {
        Integer ru = Integer.parseInt("4000");
        Document annotation = domainType.getAnnotation(Document.class);
        if (annotation != null && annotation.ru() != null && !annotation.ru().isEmpty()) {
            ru = Integer.parseInt(annotation.ru());
        }
        return ru;
    }

    private Integer getTimeToLive(Class<T> domainType) {
        Integer ttl = -1;
        Document annotation = domainType.getAnnotation(Document.class);
        if (annotation != null) {
            ttl = annotation.timeToLive();
        }
        return ttl;
    }

    private Boolean getIndexingPolicyAutomatic(Class<?> domainType) {
        Boolean isAutomatic = true;
        DocumentIndexingPolicy annotation = domainType.getAnnotation(DocumentIndexingPolicy.class);
        if (annotation != null) {
            isAutomatic = annotation.automatic();
        }
        return isAutomatic;
    }

    private IndexingMode getIndexingPolicyMode(Class<?> domainType) {
        IndexingMode mode = Constants.DEFAULT_INDEXINGPOLICY_MODE;
        DocumentIndexingPolicy annotation = domainType.getAnnotation(DocumentIndexingPolicy.class);
        if (annotation != null) {
            mode = annotation.mode();
        }
        return mode;
    }

    private List<IncludedPath> getIndexingPolicyIncludePaths(Class<?> domainType) {
        String[] rawPaths;
        ArrayList<IncludedPath> pathArrayList = new ArrayList<IncludedPath>();
        DocumentIndexingPolicy annotation = domainType.getAnnotation(DocumentIndexingPolicy.class);
        if (annotation == null || annotation.includePaths() == null || annotation.includePaths().length == 0) {
            return null;
        }
        for (String path : rawPaths = annotation.includePaths()) {
            pathArrayList.add(new IncludedPath(path));
        }
        return pathArrayList;
    }

    private List<ExcludedPath> getIndexingPolicyExcludePaths(Class<?> domainType) {
        String[] rawPaths;
        ArrayList<ExcludedPath> pathArrayList = new ArrayList<ExcludedPath>();
        DocumentIndexingPolicy annotation = domainType.getAnnotation(DocumentIndexingPolicy.class);
        if (annotation == null || annotation.excludePaths().length == 0) {
            return null;
        }
        for (String path : rawPaths = annotation.excludePaths()) {
            JSONObject obj = new JSONObject(path);
            pathArrayList.add(new ExcludedPath().path(obj.get("path").toString()));
        }
        return pathArrayList;
    }

    private boolean getIsVersioned(Class<T> domainType) {
        Field findField = ReflectionUtils.findField(domainType, (String)ETAG);
        return findField != null && findField.getType() == String.class && findField.isAnnotationPresent(Version.class);
    }

    private boolean getIsAutoCreateContainer(Class<T> domainType) {
        Document annotation = domainType.getAnnotation(Document.class);
        boolean autoCreateContainer = true;
        if (annotation != null) {
            autoCreateContainer = annotation.autoCreateCollection();
        }
        return autoCreateContainer;
    }
}

