/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.config;

import com.microsoft.azure.spring.data.cosmosdb.core.mapping.CosmosMappingContext;
import com.microsoft.azure.spring.data.cosmosdb.repository.CosmosRepository;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.CosmosRepositoryFactoryBean;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;

public class CosmosRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    public String getModuleName() {
        return "cosmosdb";
    }

    public String getModulePrefix() {
        return "cosmosdb";
    }

    public String getRepositoryFactoryBeanClassName() {
        return CosmosRepositoryFactoryBean.class.getName();
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(CosmosRepository.class);
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.emptyList();
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        if (!registry.containsBeanDefinition("cosmosMappingContext")) {
            RootBeanDefinition definition = new RootBeanDefinition(CosmosMappingContext.class);
            definition.setRole(2);
            definition.setSource(config.getSource());
            registry.registerBeanDefinition("cosmosMappingContext", (BeanDefinition)definition);
        }
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        super.postProcess(builder, source);
    }

    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return !metadata.isReactiveRepository();
    }
}

