/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.support;

import com.microsoft.azure.spring.data.cosmosdb.core.CosmosOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.CosmosMappingContext;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.CosmosRepositoryFactory;
import java.io.Serializable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class CosmosRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID>
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private CosmosOperations operations;
    private boolean mappingContextConfigured = false;

    public CosmosRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    @Autowired
    public void setCosmosOperations(CosmosOperations operations) {
        this.operations = operations;
    }

    protected final RepositoryFactorySupport createRepositoryFactory() {
        return this.getFactoryInstance(this.applicationContext);
    }

    protected RepositoryFactorySupport getFactoryInstance(ApplicationContext applicationContext) {
        return new CosmosRepositoryFactory(this.operations, applicationContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        this.mappingContextConfigured = true;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (!this.mappingContextConfigured) {
            if (this.operations != null) {
                this.setMappingContext(this.operations.getConverter().getMappingContext());
            } else {
                this.setMappingContext((MappingContext<?, ?>)new CosmosMappingContext());
            }
        }
    }
}

