/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.extensions;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.models.extensions.Channel;
import com.microsoft.graph.models.extensions.ConversationMember;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.models.extensions.Group;
import com.microsoft.graph.models.extensions.Schedule;
import com.microsoft.graph.models.extensions.TeamFunSettings;
import com.microsoft.graph.models.extensions.TeamGuestSettings;
import com.microsoft.graph.models.extensions.TeamMemberSettings;
import com.microsoft.graph.models.extensions.TeamMessagingSettings;
import com.microsoft.graph.models.extensions.TeamsAppInstallation;
import com.microsoft.graph.models.extensions.TeamsAsyncOperation;
import com.microsoft.graph.models.extensions.TeamsTemplate;
import com.microsoft.graph.models.generated.TeamSpecialization;
import com.microsoft.graph.models.generated.TeamVisibilityType;
import com.microsoft.graph.requests.extensions.ChannelCollectionPage;
import com.microsoft.graph.requests.extensions.ChannelCollectionResponse;
import com.microsoft.graph.requests.extensions.ConversationMemberCollectionPage;
import com.microsoft.graph.requests.extensions.ConversationMemberCollectionResponse;
import com.microsoft.graph.requests.extensions.TeamsAppInstallationCollectionPage;
import com.microsoft.graph.requests.extensions.TeamsAppInstallationCollectionResponse;
import com.microsoft.graph.requests.extensions.TeamsAsyncOperationCollectionPage;
import com.microsoft.graph.requests.extensions.TeamsAsyncOperationCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;

public class Team
extends Entity
implements IJsonBackedObject {
    @SerializedName(value="displayName")
    @Expose
    public String displayName;
    @SerializedName(value="description")
    @Expose
    public String description;
    @SerializedName(value="internalId")
    @Expose
    public String internalId;
    @SerializedName(value="classification")
    @Expose
    public String classification;
    @SerializedName(value="specialization")
    @Expose
    public TeamSpecialization specialization;
    @SerializedName(value="visibility")
    @Expose
    public TeamVisibilityType visibility;
    @SerializedName(value="webUrl")
    @Expose
    public String webUrl;
    @SerializedName(value="memberSettings")
    @Expose
    public TeamMemberSettings memberSettings;
    @SerializedName(value="guestSettings")
    @Expose
    public TeamGuestSettings guestSettings;
    @SerializedName(value="messagingSettings")
    @Expose
    public TeamMessagingSettings messagingSettings;
    @SerializedName(value="funSettings")
    @Expose
    public TeamFunSettings funSettings;
    @SerializedName(value="isArchived")
    @Expose
    public Boolean isArchived;
    @SerializedName(value="schedule")
    @Expose
    public Schedule schedule;
    @SerializedName(value="group")
    @Expose
    public Group group;
    @SerializedName(value="template")
    @Expose
    public TeamsTemplate template;
    public ConversationMemberCollectionPage members;
    public ChannelCollectionPage channels;
    @SerializedName(value="primaryChannel")
    @Expose
    public Channel primaryChannel;
    public TeamsAppInstallationCollectionPage installedApps;
    public TeamsAsyncOperationCollectionPage operations;
    private JsonObject rawObject;
    private ISerializer serializer;

    @Override
    public JsonObject getRawObject() {
        return this.rawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        int i;
        Entity[] array;
        JsonObject[] sourceArray;
        IJsonBackedObject response;
        this.serializer = serializer;
        this.rawObject = json;
        if (json.has("members")) {
            response = new ConversationMemberCollectionResponse();
            if (json.has("members@odata.nextLink")) {
                response.nextLink = json.get("members@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("members").toString(), JsonObject[].class);
            array = new ConversationMember[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), ConversationMember.class);
                ((ConversationMember)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.members = new ConversationMemberCollectionPage((ConversationMemberCollectionResponse)response, null);
        }
        if (json.has("channels")) {
            response = new ChannelCollectionResponse();
            if (json.has("channels@odata.nextLink")) {
                ((ChannelCollectionResponse)response).nextLink = json.get("channels@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("channels").toString(), JsonObject[].class);
            array = new Channel[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Channel.class);
                ((Channel)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            ((ChannelCollectionResponse)response).value = Arrays.asList(array);
            this.channels = new ChannelCollectionPage((ChannelCollectionResponse)response, null);
        }
        if (json.has("installedApps")) {
            response = new TeamsAppInstallationCollectionResponse();
            if (json.has("installedApps@odata.nextLink")) {
                ((TeamsAppInstallationCollectionResponse)response).nextLink = json.get("installedApps@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("installedApps").toString(), JsonObject[].class);
            array = new TeamsAppInstallation[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), TeamsAppInstallation.class);
                ((TeamsAppInstallation)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            ((TeamsAppInstallationCollectionResponse)response).value = Arrays.asList(array);
            this.installedApps = new TeamsAppInstallationCollectionPage((TeamsAppInstallationCollectionResponse)response, null);
        }
        if (json.has("operations")) {
            response = new TeamsAsyncOperationCollectionResponse();
            if (json.has("operations@odata.nextLink")) {
                ((TeamsAsyncOperationCollectionResponse)response).nextLink = json.get("operations@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("operations").toString(), JsonObject[].class);
            array = new TeamsAsyncOperation[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), TeamsAsyncOperation.class);
                ((TeamsAsyncOperation)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            ((TeamsAsyncOperationCollectionResponse)response).value = Arrays.asList(array);
            this.operations = new TeamsAsyncOperationCollectionPage((TeamsAsyncOperationCollectionResponse)response, null);
        }
    }
}

