/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.CalendarPermission;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.CalendarPermissionCollectionPage;
import com.microsoft.graph.requests.extensions.CalendarPermissionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.CalendarPermissionCollectionResponse;
import com.microsoft.graph.requests.extensions.CalendarPermissionRequestBuilder;
import com.microsoft.graph.requests.extensions.ICalendarPermissionCollectionPage;
import com.microsoft.graph.requests.extensions.ICalendarPermissionCollectionRequest;
import java.util.List;

public class CalendarPermissionCollectionRequest
extends BaseCollectionRequest<CalendarPermissionCollectionResponse, ICalendarPermissionCollectionPage>
implements ICalendarPermissionCollectionRequest {
    public CalendarPermissionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CalendarPermissionCollectionResponse.class, ICalendarPermissionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ICalendarPermissionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(CalendarPermissionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ICalendarPermissionCollectionPage get() throws ClientException {
        CalendarPermissionCollectionResponse response = (CalendarPermissionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(CalendarPermission newCalendarPermission, ICallback<CalendarPermission> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new CalendarPermissionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newCalendarPermission, callback);
    }

    @Override
    public CalendarPermission post(CalendarPermission newCalendarPermission) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CalendarPermissionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newCalendarPermission);
    }

    @Override
    public ICalendarPermissionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ICalendarPermissionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ICalendarPermissionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ICalendarPermissionCollectionPage buildFromResponse(CalendarPermissionCollectionResponse response) {
        CalendarPermissionCollectionRequestBuilder builder = response.nextLink != null ? new CalendarPermissionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        CalendarPermissionCollectionPage page = new CalendarPermissionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

