/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.OnlineMeeting;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOnlineMeetingCollectionPage;
import com.microsoft.graph.requests.extensions.IOnlineMeetingCollectionRequest;
import com.microsoft.graph.requests.extensions.OnlineMeetingCollectionPage;
import com.microsoft.graph.requests.extensions.OnlineMeetingCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OnlineMeetingCollectionResponse;
import com.microsoft.graph.requests.extensions.OnlineMeetingRequestBuilder;
import java.util.List;

public class OnlineMeetingCollectionRequest
extends BaseCollectionRequest<OnlineMeetingCollectionResponse, IOnlineMeetingCollectionPage>
implements IOnlineMeetingCollectionRequest {
    public OnlineMeetingCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnlineMeetingCollectionResponse.class, IOnlineMeetingCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IOnlineMeetingCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OnlineMeetingCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOnlineMeetingCollectionPage get() throws ClientException {
        OnlineMeetingCollectionResponse response = (OnlineMeetingCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OnlineMeeting newOnlineMeeting, ICallback<OnlineMeeting> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OnlineMeetingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnlineMeeting, callback);
    }

    @Override
    public OnlineMeeting post(OnlineMeeting newOnlineMeeting) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OnlineMeetingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnlineMeeting);
    }

    @Override
    public IOnlineMeetingCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOnlineMeetingCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOnlineMeetingCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IOnlineMeetingCollectionPage buildFromResponse(OnlineMeetingCollectionResponse response) {
        OnlineMeetingCollectionRequestBuilder builder = response.nextLink != null ? new OnlineMeetingCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OnlineMeetingCollectionPage page = new OnlineMeetingCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

