/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TargetedManagedAppPolicyAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITargetedManagedAppPolicyAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.ITargetedManagedAppPolicyAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.TargetedManagedAppPolicyAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.TargetedManagedAppPolicyAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TargetedManagedAppPolicyAssignmentCollectionResponse;
import com.microsoft.graph.requests.extensions.TargetedManagedAppPolicyAssignmentRequestBuilder;
import java.util.List;

public class TargetedManagedAppPolicyAssignmentCollectionRequest
extends BaseCollectionRequest<TargetedManagedAppPolicyAssignmentCollectionResponse, ITargetedManagedAppPolicyAssignmentCollectionPage>
implements ITargetedManagedAppPolicyAssignmentCollectionRequest {
    public TargetedManagedAppPolicyAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TargetedManagedAppPolicyAssignmentCollectionResponse.class, ITargetedManagedAppPolicyAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITargetedManagedAppPolicyAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TargetedManagedAppPolicyAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITargetedManagedAppPolicyAssignmentCollectionPage get() throws ClientException {
        TargetedManagedAppPolicyAssignmentCollectionResponse response = (TargetedManagedAppPolicyAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TargetedManagedAppPolicyAssignment newTargetedManagedAppPolicyAssignment, ICallback<TargetedManagedAppPolicyAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TargetedManagedAppPolicyAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTargetedManagedAppPolicyAssignment, callback);
    }

    @Override
    public TargetedManagedAppPolicyAssignment post(TargetedManagedAppPolicyAssignment newTargetedManagedAppPolicyAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TargetedManagedAppPolicyAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTargetedManagedAppPolicyAssignment);
    }

    @Override
    public ITargetedManagedAppPolicyAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITargetedManagedAppPolicyAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITargetedManagedAppPolicyAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ITargetedManagedAppPolicyAssignmentCollectionPage buildFromResponse(TargetedManagedAppPolicyAssignmentCollectionResponse response) {
        TargetedManagedAppPolicyAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new TargetedManagedAppPolicyAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TargetedManagedAppPolicyAssignmentCollectionPage page = new TargetedManagedAppPolicyAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

