// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.callrecords.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.callrecords.models.DeviceInfo;
import com.microsoft.graph.callrecords.models.NetworkInfo;
import com.microsoft.graph.callrecords.models.MediaStream;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Media.
 */
public class Media implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Callee Device.
     * Device information associated with the callee endpoint of this media.
     */
    @SerializedName(value = "calleeDevice", alternate = {"CalleeDevice"})
    @Expose
	@Nullable
    public DeviceInfo calleeDevice;

    /**
     * The Callee Network.
     * Network information associated with the callee endpoint of this media.
     */
    @SerializedName(value = "calleeNetwork", alternate = {"CalleeNetwork"})
    @Expose
	@Nullable
    public NetworkInfo calleeNetwork;

    /**
     * The Caller Device.
     * Device information associated with the caller endpoint of this media.
     */
    @SerializedName(value = "callerDevice", alternate = {"CallerDevice"})
    @Expose
	@Nullable
    public DeviceInfo callerDevice;

    /**
     * The Caller Network.
     * Network information associated with the caller endpoint of this media.
     */
    @SerializedName(value = "callerNetwork", alternate = {"CallerNetwork"})
    @Expose
	@Nullable
    public NetworkInfo callerNetwork;

    /**
     * The Label.
     * How the media was identified during media negotiation stage.
     */
    @SerializedName(value = "label", alternate = {"Label"})
    @Expose
	@Nullable
    public String label;

    /**
     * The Streams.
     * Network streams associated with this media.
     */
    @SerializedName(value = "streams", alternate = {"Streams"})
    @Expose
	@Nullable
    public java.util.List<MediaStream> streams;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
