// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.externalconnectors.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.externalconnectors.models.ConnectionOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Connection Operation Request.
 */
public class ConnectionOperationRequest extends BaseRequest<ConnectionOperation> {
	
    /**
     * The request for the ConnectionOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ConnectionOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConnectionOperation.class);
    }

    /**
     * Gets the ConnectionOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConnectionOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ConnectionOperation from the service
     *
     * @return the ConnectionOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ConnectionOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConnectionOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ConnectionOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ConnectionOperation with a source
     *
     * @param sourceConnectionOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConnectionOperation> patchAsync(@Nonnull final ConnectionOperation sourceConnectionOperation) {
        return sendAsync(HttpMethod.PATCH, sourceConnectionOperation);
    }

    /**
     * Patches this ConnectionOperation with a source
     *
     * @param sourceConnectionOperation the source object with updates
     * @return the updated ConnectionOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ConnectionOperation patch(@Nonnull final ConnectionOperation sourceConnectionOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceConnectionOperation);
    }

    /**
     * Creates a ConnectionOperation with a new object
     *
     * @param newConnectionOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConnectionOperation> postAsync(@Nonnull final ConnectionOperation newConnectionOperation) {
        return sendAsync(HttpMethod.POST, newConnectionOperation);
    }

    /**
     * Creates a ConnectionOperation with a new object
     *
     * @param newConnectionOperation the new object to create
     * @return the created ConnectionOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ConnectionOperation post(@Nonnull final ConnectionOperation newConnectionOperation) throws ClientException {
        return send(HttpMethod.POST, newConnectionOperation);
    }

    /**
     * Creates a ConnectionOperation with a new object
     *
     * @param newConnectionOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConnectionOperation> putAsync(@Nonnull final ConnectionOperation newConnectionOperation) {
        return sendAsync(HttpMethod.PUT, newConnectionOperation);
    }

    /**
     * Creates a ConnectionOperation with a new object
     *
     * @param newConnectionOperation the object to create/update
     * @return the created ConnectionOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ConnectionOperation put(@Nonnull final ConnectionOperation newConnectionOperation) throws ClientException {
        return send(HttpMethod.PUT, newConnectionOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ConnectionOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ConnectionOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

