// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.AccessPackageFilterByCurrentUserOptions;
import com.microsoft.graph.models.AccessPackage;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Filter By Current User Parameter Set.
 */
public class AccessPackageFilterByCurrentUserParameterSet {
    /**
     * The on.
     * 
     */
    @SerializedName(value = "on", alternate = {"On"})
    @Expose
	@Nullable
    public AccessPackageFilterByCurrentUserOptions on;


    /**
     * Instiaciates a new AccessPackageFilterByCurrentUserParameterSet
     */
    public AccessPackageFilterByCurrentUserParameterSet() {}
    /**
     * Instiaciates a new AccessPackageFilterByCurrentUserParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected AccessPackageFilterByCurrentUserParameterSet(@Nonnull final AccessPackageFilterByCurrentUserParameterSetBuilder builder) {
        this.on = builder.on;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static AccessPackageFilterByCurrentUserParameterSetBuilder newBuilder() {
        return new AccessPackageFilterByCurrentUserParameterSetBuilder();
    }
    /**
     * Fluent builder for the AccessPackageFilterByCurrentUserParameterSet
     */
    public static final class AccessPackageFilterByCurrentUserParameterSetBuilder {
        /**
         * The on parameter value
         */
        @Nullable
        protected AccessPackageFilterByCurrentUserOptions on;
        /**
         * Sets the On
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public AccessPackageFilterByCurrentUserParameterSetBuilder withOn(@Nullable final AccessPackageFilterByCurrentUserOptions val) {
            this.on = val;
            return this;
        }
        /**
         * Instanciates a new AccessPackageFilterByCurrentUserParameterSetBuilder
         */
        @Nullable
        protected AccessPackageFilterByCurrentUserParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public AccessPackageFilterByCurrentUserParameterSet build() {
            return new AccessPackageFilterByCurrentUserParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.on != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("on", on));
        }
        return result;
    }
}
