// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Fido2AuthenticationMethod;
import com.microsoft.graph.models.AuthenticationMethod;
import com.microsoft.graph.models.MicrosoftAuthenticatorAuthenticationMethod;
import com.microsoft.graph.models.LongRunningOperation;
import com.microsoft.graph.models.PasswordAuthenticationMethod;
import com.microsoft.graph.models.TemporaryAccessPassAuthenticationMethod;
import com.microsoft.graph.models.WindowsHelloForBusinessAuthenticationMethod;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.Fido2AuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.AuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.MicrosoftAuthenticatorAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.LongRunningOperationCollectionPage;
import com.microsoft.graph.requests.PasswordAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.TemporaryAccessPassAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.WindowsHelloForBusinessAuthenticationMethodCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication.
 */
public class Authentication extends Entity implements IJsonBackedObject {


    /**
     * The Fido2Methods.
     * Represents the FIDO2 security keys registered to a user for authentication.
     */
    @SerializedName(value = "fido2Methods", alternate = {"Fido2Methods"})
    @Expose
	@Nullable
    public Fido2AuthenticationMethodCollectionPage fido2Methods;

    /**
     * The Methods.
     * Represents all authentication methods registered to a user.
     */
    @SerializedName(value = "methods", alternate = {"Methods"})
    @Expose
	@Nullable
    public AuthenticationMethodCollectionPage methods;

    /**
     * The Microsoft Authenticator Methods.
     * The details of the Microsoft Authenticator app registered to a user for authentication.
     */
    @SerializedName(value = "microsoftAuthenticatorMethods", alternate = {"MicrosoftAuthenticatorMethods"})
    @Expose
	@Nullable
    public MicrosoftAuthenticatorAuthenticationMethodCollectionPage microsoftAuthenticatorMethods;

    /**
     * The Operations.
     * 
     */
    @SerializedName(value = "operations", alternate = {"Operations"})
    @Expose
	@Nullable
    public LongRunningOperationCollectionPage operations;

    /**
     * The Password Methods.
     * Represents the details of the password authentication method registered to a user for authentication.
     */
    @SerializedName(value = "passwordMethods", alternate = {"PasswordMethods"})
    @Expose
	@Nullable
    public PasswordAuthenticationMethodCollectionPage passwordMethods;

    /**
     * The Temporary Access Pass Methods.
     * Represents a Temporary Access Pass registered to a user for authentication through time-limited passcodes.
     */
    @SerializedName(value = "temporaryAccessPassMethods", alternate = {"TemporaryAccessPassMethods"})
    @Expose
	@Nullable
    public TemporaryAccessPassAuthenticationMethodCollectionPage temporaryAccessPassMethods;

    /**
     * The Windows Hello For Business Methods.
     * Represents the Windows Hello for Business authentication method registered to a user for authentication.
     */
    @SerializedName(value = "windowsHelloForBusinessMethods", alternate = {"WindowsHelloForBusinessMethods"})
    @Expose
	@Nullable
    public WindowsHelloForBusinessAuthenticationMethodCollectionPage windowsHelloForBusinessMethods;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("fido2Methods")) {
            fido2Methods = serializer.deserializeObject(json.get("fido2Methods"), Fido2AuthenticationMethodCollectionPage.class);
        }

        if (json.has("methods")) {
            methods = serializer.deserializeObject(json.get("methods"), AuthenticationMethodCollectionPage.class);
        }

        if (json.has("microsoftAuthenticatorMethods")) {
            microsoftAuthenticatorMethods = serializer.deserializeObject(json.get("microsoftAuthenticatorMethods"), MicrosoftAuthenticatorAuthenticationMethodCollectionPage.class);
        }

        if (json.has("operations")) {
            operations = serializer.deserializeObject(json.get("operations"), LongRunningOperationCollectionPage.class);
        }

        if (json.has("passwordMethods")) {
            passwordMethods = serializer.deserializeObject(json.get("passwordMethods"), PasswordAuthenticationMethodCollectionPage.class);
        }

        if (json.has("temporaryAccessPassMethods")) {
            temporaryAccessPassMethods = serializer.deserializeObject(json.get("temporaryAccessPassMethods"), TemporaryAccessPassAuthenticationMethodCollectionPage.class);
        }

        if (json.has("windowsHelloForBusinessMethods")) {
            windowsHelloForBusinessMethods = serializer.deserializeObject(json.get("windowsHelloForBusinessMethods"), WindowsHelloForBusinessAuthenticationMethodCollectionPage.class);
        }
    }
}
