// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ConversationThread;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.ConversationThreadCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conversation.
 */
public class Conversation extends Entity implements IJsonBackedObject {


    /**
     * The Has Attachments.
     * Indicates whether any of the posts within this Conversation has at least one attachment. Supports $filter (eq, ne) and $search.
     */
    @SerializedName(value = "hasAttachments", alternate = {"HasAttachments"})
    @Expose
	@Nullable
    public Boolean hasAttachments;

    /**
     * The Last Delivered Date Time.
     * The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Supports $filter (eq, ne, le, ge).
     */
    @SerializedName(value = "lastDeliveredDateTime", alternate = {"LastDeliveredDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastDeliveredDateTime;

    /**
     * The Preview.
     * A short summary from the body of the latest post in this conversation.
     */
    @SerializedName(value = "preview", alternate = {"Preview"})
    @Expose
	@Nullable
    public String preview;

    /**
     * The Topic.
     * The topic of the conversation. This property can be set when the conversation is created, but it cannot be updated.
     */
    @SerializedName(value = "topic", alternate = {"Topic"})
    @Expose
	@Nullable
    public String topic;

    /**
     * The Unique Senders.
     * All the users that sent a message to this Conversation.
     */
    @SerializedName(value = "uniqueSenders", alternate = {"UniqueSenders"})
    @Expose
	@Nullable
    public java.util.List<String> uniqueSenders;

    /**
     * The Threads.
     * A collection of all the conversation threads in the conversation. A navigation property. Read-only. Nullable.
     */
    @SerializedName(value = "threads", alternate = {"Threads"})
    @Expose
	@Nullable
    public ConversationThreadCollectionPage threads;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("threads")) {
            threads = serializer.deserializeObject(json.get("threads"), ConversationThreadCollectionPage.class);
        }
    }
}
