// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.AssignmentOrder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity User Flow Attribute Assignment Set Order Parameter Set.
 */
public class IdentityUserFlowAttributeAssignmentSetOrderParameterSet {
    /**
     * The new Assignment Order.
     * 
     */
    @SerializedName(value = "newAssignmentOrder", alternate = {"NewAssignmentOrder"})
    @Expose
	@Nullable
    public AssignmentOrder newAssignmentOrder;


    /**
     * Instiaciates a new IdentityUserFlowAttributeAssignmentSetOrderParameterSet
     */
    public IdentityUserFlowAttributeAssignmentSetOrderParameterSet() {}
    /**
     * Instiaciates a new IdentityUserFlowAttributeAssignmentSetOrderParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected IdentityUserFlowAttributeAssignmentSetOrderParameterSet(@Nonnull final IdentityUserFlowAttributeAssignmentSetOrderParameterSetBuilder builder) {
        this.newAssignmentOrder = builder.newAssignmentOrder;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static IdentityUserFlowAttributeAssignmentSetOrderParameterSetBuilder newBuilder() {
        return new IdentityUserFlowAttributeAssignmentSetOrderParameterSetBuilder();
    }
    /**
     * Fluent builder for the IdentityUserFlowAttributeAssignmentSetOrderParameterSet
     */
    public static final class IdentityUserFlowAttributeAssignmentSetOrderParameterSetBuilder {
        /**
         * The newAssignmentOrder parameter value
         */
        @Nullable
        protected AssignmentOrder newAssignmentOrder;
        /**
         * Sets the NewAssignmentOrder
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public IdentityUserFlowAttributeAssignmentSetOrderParameterSetBuilder withNewAssignmentOrder(@Nullable final AssignmentOrder val) {
            this.newAssignmentOrder = val;
            return this;
        }
        /**
         * Instanciates a new IdentityUserFlowAttributeAssignmentSetOrderParameterSetBuilder
         */
        @Nullable
        protected IdentityUserFlowAttributeAssignmentSetOrderParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public IdentityUserFlowAttributeAssignmentSetOrderParameterSet build() {
            return new IdentityUserFlowAttributeAssignmentSetOrderParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.newAssignmentOrder != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("newAssignmentOrder", newAssignmentOrder));
        }
        return result;
    }
}
