// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.Site;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Site Remove Parameter Set.
 */
public class SiteRemoveParameterSet {
    /**
     * The value.
     * 
     */
    @SerializedName(value = "value", alternate = {"Value"})
    @Expose
	@Nullable
    public java.util.List<Site> value;


    /**
     * Instiaciates a new SiteRemoveParameterSet
     */
    public SiteRemoveParameterSet() {}
    /**
     * Instiaciates a new SiteRemoveParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected SiteRemoveParameterSet(@Nonnull final SiteRemoveParameterSetBuilder builder) {
        this.value = builder.value;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static SiteRemoveParameterSetBuilder newBuilder() {
        return new SiteRemoveParameterSetBuilder();
    }
    /**
     * Fluent builder for the SiteRemoveParameterSet
     */
    public static final class SiteRemoveParameterSetBuilder {
        /**
         * The value parameter value
         */
        @Nullable
        protected java.util.List<Site> value;
        /**
         * Sets the Value
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public SiteRemoveParameterSetBuilder withValue(@Nullable final java.util.List<Site> val) {
            this.value = val;
            return this;
        }
        /**
         * Instanciates a new SiteRemoveParameterSetBuilder
         */
        @Nullable
        protected SiteRemoveParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public SiteRemoveParameterSet build() {
            return new SiteRemoveParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.value != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("value", value));
        }
        return result;
    }
}
