// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Video.
 */
public class Video implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Audio Bits Per Sample.
     * Number of audio bits per sample.
     */
    @SerializedName(value = "audioBitsPerSample", alternate = {"AudioBitsPerSample"})
    @Expose
	@Nullable
    public Integer audioBitsPerSample;

    /**
     * The Audio Channels.
     * Number of audio channels.
     */
    @SerializedName(value = "audioChannels", alternate = {"AudioChannels"})
    @Expose
	@Nullable
    public Integer audioChannels;

    /**
     * The Audio Format.
     * Name of the audio format (AAC, MP3, etc.).
     */
    @SerializedName(value = "audioFormat", alternate = {"AudioFormat"})
    @Expose
	@Nullable
    public String audioFormat;

    /**
     * The Audio Samples Per Second.
     * Number of audio samples per second.
     */
    @SerializedName(value = "audioSamplesPerSecond", alternate = {"AudioSamplesPerSecond"})
    @Expose
	@Nullable
    public Integer audioSamplesPerSecond;

    /**
     * The Bitrate.
     * Bit rate of the video in bits per second.
     */
    @SerializedName(value = "bitrate", alternate = {"Bitrate"})
    @Expose
	@Nullable
    public Integer bitrate;

    /**
     * The Duration.
     * Duration of the file in milliseconds.
     */
    @SerializedName(value = "duration", alternate = {"Duration"})
    @Expose
	@Nullable
    public Long duration;

    /**
     * The Four CC.
     * 'Four character code' name of the video format.
     */
    @SerializedName(value = "fourCC", alternate = {"FourCC"})
    @Expose
	@Nullable
    public String fourCC;

    /**
     * The Frame Rate.
     * Frame rate of the video.
     */
    @SerializedName(value = "frameRate", alternate = {"FrameRate"})
    @Expose
	@Nullable
    public Double frameRate;

    /**
     * The Height.
     * Height of the video, in pixels.
     */
    @SerializedName(value = "height", alternate = {"Height"})
    @Expose
	@Nullable
    public Integer height;

    /**
     * The Width.
     * Width of the video, in pixels.
     */
    @SerializedName(value = "width", alternate = {"Width"})
    @Expose
	@Nullable
    public Integer width;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
