// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Average If Parameter Set.
 */
public class WorkbookFunctionsAverageIfParameterSet {
    /**
     * The range.
     * 
     */
    @SerializedName(value = "range", alternate = {"Range"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement range;

    /**
     * The criteria.
     * 
     */
    @SerializedName(value = "criteria", alternate = {"Criteria"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement criteria;

    /**
     * The average Range.
     * 
     */
    @SerializedName(value = "averageRange", alternate = {"AverageRange"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement averageRange;


    /**
     * Instiaciates a new WorkbookFunctionsAverageIfParameterSet
     */
    public WorkbookFunctionsAverageIfParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsAverageIfParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsAverageIfParameterSet(@Nonnull final WorkbookFunctionsAverageIfParameterSetBuilder builder) {
        this.range = builder.range;
        this.criteria = builder.criteria;
        this.averageRange = builder.averageRange;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsAverageIfParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsAverageIfParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsAverageIfParameterSet
     */
    public static final class WorkbookFunctionsAverageIfParameterSetBuilder {
        /**
         * The range parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement range;
        /**
         * Sets the Range
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsAverageIfParameterSetBuilder withRange(@Nullable final com.google.gson.JsonElement val) {
            this.range = val;
            return this;
        }
        /**
         * The criteria parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement criteria;
        /**
         * Sets the Criteria
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsAverageIfParameterSetBuilder withCriteria(@Nullable final com.google.gson.JsonElement val) {
            this.criteria = val;
            return this;
        }
        /**
         * The averageRange parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement averageRange;
        /**
         * Sets the AverageRange
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsAverageIfParameterSetBuilder withAverageRange(@Nullable final com.google.gson.JsonElement val) {
            this.averageRange = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsAverageIfParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsAverageIfParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsAverageIfParameterSet build() {
            return new WorkbookFunctionsAverageIfParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.range != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("range", range));
        }
        if(this.criteria != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("criteria", criteria));
        }
        if(this.averageRange != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("averageRange", averageRange));
        }
        return result;
    }
}
